/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import ome.xml.model.Filter;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleList;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ArcConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ChannelConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DetectorConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DichroicConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ExperimentConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.FilamentConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.FilterConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.GenericExcitationSourceConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ImageConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ImagingEnvConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.LEDConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.LaserConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ObjectiveConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleTree;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.MDEConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.TagNames;

public class ModuleController {
    private static ModuleController self = new ModuleController();
    private MDEConfiguration mdeConf;
    private String micName;
    private String mdeConfigPath;
    private boolean filterRequired;

    public static ModuleController getInstance() {
        return self;
    }

    public ModuleTreeElement createElement(String type, DefaultMutableTreeNode parent) {
        if (this.getContentOfType(type) == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] no object content found for type  " + type + "[ModuleController::createElement]");
        }
        return new ModuleTreeElement(type, null, "", this.getContentOfType(type), parent);
    }

    public DefaultMutableTreeNode getTree() {
        return ModuleTree.cloneTreeNode(this.mdeConf.getTree(this.micName));
    }

    public HashMap<String, ModuleContent> getAvailableContent() {
        if (this.mdeConf == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] mdeConf not available");
            return this.initDefaultOMEObjects();
        }
        return this.mdeConf.getAvailableContentList(this.getCurrentMicName());
    }

    public HashMap<String, ModuleContent> initDefaultOMEObjects() {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] init DEFAULT content [ModuleController]");
        HashMap<String, ModuleContent> defaultContent = new HashMap<String, ModuleContent>();
        String thisType = "OME:Image";
        ModuleContent img = new ModuleContent(new ImageConverter().convertData(null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, img);
        thisType = "OME:Experiment";
        ModuleContent exp = new ModuleContent(new ExperimentConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, exp);
        thisType = "OME:Objective";
        ModuleContent obj = new ModuleContent(new ObjectiveConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, obj);
        thisType = "OME:Detector";
        ModuleContent detector = new ModuleContent(new DetectorConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, detector);
        thisType = "OME:Channel";
        ModuleContent channel = new ModuleContent(new ChannelConverter().convertData(null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, channel);
        thisType = "OME:Laser";
        ModuleContent laser = new ModuleContent(new LaserConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, laser);
        thisType = "OME:Filament";
        ModuleContent fila = new ModuleContent(new FilamentConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, fila);
        thisType = "OME:Arc";
        ModuleContent arc = new ModuleContent(new ArcConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, arc);
        thisType = "OME:LightEmittingDiode";
        ModuleContent led = new ModuleContent(new LEDConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, led);
        thisType = "OME:Generic_Excitation_Src";
        ModuleContent ges = new ModuleContent(new GenericExcitationSourceConverter().convertData(null, null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, ges);
        thisType = "OME:Filter";
        ModuleContent filter = new ModuleContent(new FilterConverter().convertData((Filter)null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, filter);
        thisType = "OME:Dichroic";
        ModuleContent dich = new ModuleContent(new DichroicConverter().convertData(null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, dich);
        thisType = "OME:ImagingEnvironment";
        ModuleContent imEnv = new ModuleContent(new ImagingEnvConverter().convertData(null), thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, imEnv);
        thisType = "OME:LightSource";
        ModuleContent lSrc = new ModuleContent(null, thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, lSrc);
        thisType = "OME:LightPath";
        ModuleContent lp = new ModuleContent(null, thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, lp);
        thisType = "OME:EmissionFilter";
        ModuleContent lpEm = new ModuleContent(null, thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, lpEm);
        thisType = "OME:ExcitationFilter";
        ModuleContent lpEx = new ModuleContent(null, thisType, TagNames.getParents(thisType));
        defaultContent.put(thisType, lpEx);
        return defaultContent;
    }

    public ModuleList getInstrumentsForCurrentMic() {
        if (this.mdeConf != null) {
            return this.mdeConf.getPredefinitions(this.micName);
        }
        return null;
    }

    public ModuleList getInstrumentsForMic(String micName) {
        if (this.mdeConf != null) {
            return this.mdeConf.getPredefinitions(micName);
        }
        return null;
    }

    public List<ModuleContent> getInstrumentsOfType(String instrumentType) {
        ModuleList val;
        if (this.mdeConf != null && (val = this.mdeConf.getPredefinitions(this.micName)) != null) {
            return (List)val.get(instrumentType);
        }
        return null;
    }

    public ModuleContent getContentOfType(String moduleType) {
        if (this.mdeConf == null) {
            ImporterAgent.getRegistry().getLogger().error((Object)this, "[MDE] no configuration available!");
            return null;
        }
        if (this.micName == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] No microscope is given, return object define in UNIVERSAL [MDEController::getContentOfType]");
            return this.mdeConf.getContent("Universal", moduleType);
        }
        return this.mdeConf.getContent(this.micName, moduleType);
    }

    public DefaultMutableTreeNode cloneTreeStructure(DefaultMutableTreeNode node, DefaultMutableTreeNode p) {
        DefaultMutableTreeNode cloneNode = null;
        cloneNode = new DefaultMutableTreeNode(ModuleController.getInstance().createElement(((ModuleTreeElement)node.getUserObject()).getType(), p));
        for (int i = 0; i < node.getChildCount(); ++i) {
            cloneNode.add(this.cloneTreeStructure((DefaultMutableTreeNode)node.getChildAt(i), cloneNode));
        }
        return cloneNode;
    }

    public void setCurrentMicName(String micName) {
        this.micName = micName;
    }

    public void setFilterRequired(boolean filterval) {
        this.filterRequired = filterval;
    }

    public boolean shouldFilterRequired() {
        return this.filterRequired;
    }

    public void initMDEConfiguration(String curMic, String configPath) {
        this.setCurrentMicName(curMic);
        this.mdeConfigPath = configPath;
        this.mdeConf = new MDEConfiguration(configPath);
    }

    private HashMap<String, ModuleContent> cloneContent(HashMap<String, ModuleContent> defaultContent) {
        HashMap<String, ModuleContent> clone = new HashMap<String, ModuleContent>();
        for (Map.Entry<String, ModuleContent> entry : defaultContent.entrySet()) {
            clone.put(entry.getKey(), new ModuleContent(entry.getValue()));
        }
        return clone;
    }

    public void setMDEConfiguration(MDEConfiguration conf) {
        this.mdeConf = conf;
    }

    public MDEConfiguration getMDEConfiguration() {
        if (this.mdeConf == null) {
            this.initMDEConfiguration(this.getCurrentMicName(), this.mdeConfigPath);
        }
        return this.mdeConf;
    }

    public String[] getPossibleChilds(String type) {
        HashMap<String, ModuleContent> contentList;
        ArrayList<String> list = new ArrayList<String>();
        if (this.mdeConf != null && (contentList = this.mdeConf.getAvailableContentList(this.getCurrentMicName())) != null) {
            for (Map.Entry<String, ModuleContent> entry : contentList.entrySet()) {
                if (!entry.getValue().hasParent(type)) continue;
                list.add(entry.getKey());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String getCurrentMicName() {
        return this.micName;
    }

    public String[] getMicNames() {
        String[] micNames;
        if (this.mdeConf != null && (micNames = this.mdeConf.getMicNames()) != null) {
            String[] list = new String[micNames.length + 1];
            list[0] = "Universal";
            for (int i = 0; i < micNames.length; ++i) {
                list[i + 1] = micNames[i];
            }
            return list;
        }
        String[] stringArray = new String[1];
        stringArray[0] = "Universal";
        return stringArray;
    }

    public int getMicIndex(String microscope) {
        return Arrays.asList(this.getMicNames()).indexOf(microscope);
    }

    public String getStandardUnitSymbolByName(String parent, String tagName) {
        if (this.mdeConf == null) {
            return "";
        }
        return this.mdeConf.getStandardUnitSymbolByName(parent, tagName);
    }

    public void printObjects() {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- PRINT objects for selected category/microscope:");
        if (this.mdeConf == null) {
            return;
        }
        this.mdeConf.printObjects(this.micName);
    }

    public boolean configurationExists(String type) {
        if (this.mdeConf != null) {
            return this.mdeConf.configurationExists(this.getCurrentMicName(), type);
        }
        return false;
    }
}

