/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components;

import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;

public class ModuleTreeElement {
    private String name;
    private String type;
    private String id;
    private int childIndex;
    private ModuleContent data;

    public ModuleTreeElement(ModuleContent c, DefaultMutableTreeNode parent) {
        this.type = c == null ? "OME-Model" : c.getType();
        this.id = null;
        this.data = null;
        this.childIndex = MDEHelper.getChildCount(this.type, parent);
    }

    public ModuleTreeElement(String type, String name, String index, ModuleContent data, DefaultMutableTreeNode parent) {
        this.type = type;
        this.name = name;
        this.id = index;
        this.data = data;
        this.childIndex = MDEHelper.getChildCount(type, parent);
    }

    public ModuleTreeElement(ModuleTreeElement orig) {
        this.type = orig.type;
        this.id = orig.id;
        this.childIndex = orig.childIndex;
        this.data = new ModuleContent(orig.getData());
    }

    public ModuleContent getData() {
        return this.data;
    }

    public void setData(ModuleContent data) {
        this.data = data;
        if (data != null) {
            this.id = data.getAttributeValue("ID");
            this.name = data.getAttributeValue("Model");
        }
    }

    public void setProperties(ModuleConfiguration conf) {
        if (this.data != null) {
            this.data.setProperties(conf);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndex() {
        return this.id;
    }

    public void setChildIndex(DefaultMutableTreeNode node) {
        this.childIndex = MDEHelper.getChildCount(this.type, node);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasRequiredData() {
        if (this.data != null) {
            return this.data.hasRequiredData();
        }
        return false;
    }

    public boolean isContainer() {
        return this.data == null || this.data.getList() == null;
    }

    public String toString() {
        String elementID = "[" + this.type + "]{" + this.childIndex + "}";
        return elementID;
    }

    public String getElementName() {
        return "[" + this.type + "]{" + this.childIndex + "}";
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public void printContent() {
        if (this.data == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- PRINT ModuleContent: \n\tcontent is null!");
        } else {
            this.data.print();
        }
    }

    public void resetInput() {
        if (this.data == null) {
            return;
        }
        this.data.resetInput();
    }
}

