/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class BirdEyeViewComponent
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final String DISPLAY_REGION_PROPERTY = "displayRegion";
    static final String FULL_DISPLAY_PROPERTY = "fullDisplay";
    static final int BORDER = 2;
    static final int BORDER_5 = 10;
    private static final Color FILL_COLOR = Color.LIGHT_GRAY;
    private static final Color STROKE_COLOR = Color.BLACK;
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    private static final Color SELECTION_COLOR = new Color(255, 0, 0, 100);
    private static final Color SELECTION_COLOR_BORDER = Color.red;
    private static final Color SELECTION_BLUE_COLOR = new Color(0, 0, 255, 100);
    private static final Color SELECTION_BLUE_COLOR_BORDER = Color.blue;
    private BufferedImage pImage = null;
    private Color color;
    private Color colorBorder;
    private int w = 30;
    private int h = 20;
    private int bx;
    private int by;
    private int ax;
    private int ay;
    private boolean release = true;
    private boolean bover;
    private boolean locked = false;
    private int px;
    private int py;
    private int bdifx = 0;
    private int bdify = 0;
    private boolean fullDisplay = true;
    private int v = 4;
    private int xArrow = 2;
    private int yArrow = 2;
    private Rectangle imageRectangle;
    private Rectangle cross;
    private int canvasWidth;
    private int canvasHeight;
    private int mouseX;
    private int mouseY;
    private int locationIndex;
    private boolean inCross = false;

    private boolean inSelection(int x, int y) {
        if (x < this.bx || x > this.bx + this.w) {
            return false;
        }
        return y >= this.by && y <= this.by + this.h;
    }

    private boolean isSameSelection(Rectangle r) {
        if (r.width == this.imageRectangle.width && r.height == this.imageRectangle.height) {
            return true;
        }
        return r.x == this.px && r.y == this.py;
    }

    private void setCrossLocation() {
        if (!this.fullDisplay) {
            this.cross.x = 0;
            this.cross.y = 0;
            return;
        }
        switch (this.locationIndex) {
            case 1: {
                this.cross.x = this.canvasWidth - this.cross.width;
                this.cross.y = this.canvasHeight - this.cross.height;
                break;
            }
            case 0: {
                this.cross.x = 0;
                this.cross.y = 0;
            }
        }
    }

    private boolean inImage() {
        boolean b = true;
        if (this.bx < this.imageRectangle.x) {
            this.bx = this.imageRectangle.x;
            b = false;
        }
        if (this.by < this.imageRectangle.y) {
            this.by = this.imageRectangle.y;
            b = false;
        }
        if (!b) {
            return b;
        }
        if (this.bx + this.w > this.imageRectangle.width) {
            this.bx = this.imageRectangle.width - this.w;
            b = false;
        }
        if (this.by + this.h > this.imageRectangle.height) {
            this.by = this.imageRectangle.height - this.h;
            b = false;
        }
        return b;
    }

    private void setCursor(int x, int y) {
        boolean b = this.inSelection(x, y);
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    BirdEyeViewComponent(int locationIndex) {
        switch (locationIndex) {
            case 0: 
            case 1: {
                this.locationIndex = locationIndex;
                break;
            }
            default: {
                this.locationIndex = 0;
            }
        }
        this.cross = new Rectangle(0, 0, 10, 10);
    }

    BirdEyeViewComponent() {
        this(0);
    }

    Rectangle getSelectionRegion() {
        return new Rectangle(this.bx, this.by, this.w, this.h);
    }

    void setSelection(int x, int y, int w, int h) {
        this.bx = x;
        this.by = y;
        if (w > this.imageRectangle.width) {
            w = this.imageRectangle.width;
        }
        if (h > this.imageRectangle.height) {
            h = this.imageRectangle.height;
        }
        this.w = w;
        this.h = h;
        if (this.bx < 0) {
            this.w += x;
            this.bx = 0;
        } else if (this.bx + w > this.imageRectangle.width) {
            this.w = this.imageRectangle.width - this.bx;
        }
        if (this.by < 0) {
            this.h += y;
            this.by = 0;
        } else if (this.by + h > this.imageRectangle.height) {
            this.h = this.imageRectangle.height - this.by;
        }
        this.repaint();
    }

    void setCanvasSize(int w, int h) {
        this.setSize(w, h);
        this.canvasWidth = w;
        this.canvasHeight = h;
        this.setCrossLocation();
    }

    void setImage(BufferedImage image) {
        this.pImage = image;
        if (image != null) {
            Color c;
            long count = 0L;
            long totalRed = 0L;
            long totalGreen = 0L;
            long totalBlue = 0L;
            for (int i = 0; i < image.getWidth(); i += 10) {
                for (int j = 0; j < image.getHeight(); j += 10) {
                    ++count;
                    c = new Color(image.getRGB(i, j));
                    totalRed += (long)c.getRed();
                    totalGreen += (long)c.getGreen();
                    totalBlue += (long)c.getBlue();
                }
            }
            c = new Color((int)(totalRed / count), (int)(totalGreen / count), (int)(totalBlue / count));
            int result = UIUtilities.getColorRange(c);
            if (result == 0) {
                this.setSelectionColor(SELECTION_BLUE_COLOR);
            } else {
                this.setSelectionColor(SELECTION_COLOR);
            }
            this.setCanvasSize(image.getWidth(), image.getHeight());
            this.imageRectangle = new Rectangle(0, 0, this.pImage.getWidth(), this.pImage.getHeight());
            if (this.w == 0) {
                this.w = image.getWidth();
            }
            if (this.h == 0) {
                this.h = image.getHeight();
            }
        }
        this.repaint();
    }

    void setSelectionColor(Color color) {
        if (color != null) {
            this.color = color;
            this.colorBorder = color.equals(SELECTION_COLOR) ? SELECTION_COLOR_BORDER : SELECTION_BLUE_COLOR_BORDER;
        }
    }

    int getLocationIndex() {
        return this.locationIndex;
    }

    void setup(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setSelectionColor(SELECTION_COLOR);
        this.bx = x;
        this.by = x;
        this.fullDisplay = true;
        this.installListeners(true);
    }

    void installListeners(boolean add) {
        if (add) {
            if (!Arrays.asList(this.getMouseListeners()).contains(this)) {
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
            }
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
    }

    Dimension getImageSize() {
        if (this.pImage == null) {
            return null;
        }
        return new Dimension(this.pImage.getWidth(), this.pImage.getHeight());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.pImage == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        this.setCrossLocation();
        if (!this.fullDisplay) {
            g2D.setColor(FILL_COLOR);
            g2D.fillRect(this.cross.x, this.cross.y, this.cross.width, this.cross.height);
            g2D.setColor(STROKE_COLOR);
            switch (this.locationIndex) {
                case 1: {
                    g2D.drawLine(this.xArrow, this.yArrow, 10, 10);
                    g2D.drawLine(this.xArrow, this.yArrow, this.xArrow + this.v, this.yArrow);
                    g2D.drawLine(this.xArrow, this.yArrow, this.xArrow, this.yArrow + this.v);
                    break;
                }
                default: {
                    g2D.drawLine(this.xArrow, this.yArrow, 10 - this.xArrow, 10 - this.yArrow);
                    g2D.drawLine(10 - this.xArrow, 10 - this.yArrow, 10 - this.xArrow, 10 - this.yArrow - this.v);
                    g2D.drawLine(10 - this.xArrow, 10 - this.yArrow, 10 - this.xArrow - this.v, 10 - this.yArrow);
                }
            }
            return;
        }
        if (this.imageRectangle == null) {
            g2D.setColor(BORDER_COLOR);
        }
        this.setSize(this.canvasWidth, this.canvasHeight);
        g2D.drawImage(this.pImage, null, 0, 0);
        g2D.setColor(FILL_COLOR);
        g2D.fillRect(this.cross.x, this.cross.y, this.cross.width, this.cross.height);
        g2D.setColor(STROKE_COLOR);
        switch (this.locationIndex) {
            case 1: {
                g2D.drawLine(this.canvasWidth - 10 + this.xArrow, this.canvasHeight - 10 + this.yArrow, this.canvasWidth - this.xArrow, this.canvasHeight - this.yArrow);
                g2D.drawLine(this.canvasWidth - this.xArrow - this.v, this.canvasHeight - this.yArrow, this.canvasWidth - this.xArrow, this.canvasHeight - this.yArrow);
                g2D.drawLine(this.canvasWidth - this.xArrow, this.canvasHeight - this.yArrow - this.v, this.canvasWidth - this.xArrow, this.canvasHeight - this.yArrow);
                break;
            }
            default: {
                g2D.drawLine(this.xArrow, this.yArrow, this.xArrow + this.v, this.yArrow);
                g2D.drawLine(this.xArrow, this.yArrow, this.xArrow, this.yArrow + this.v);
                g2D.drawLine(this.xArrow, this.yArrow, 10, 10);
            }
        }
        g2D.setColor(this.color);
        g2D.fillRect(this.bx, this.by, this.w, this.h);
        if (this.colorBorder != null) {
            g2D.setColor(this.colorBorder);
            g2D.drawRect(this.bx, this.by, this.w, this.h);
            if (!this.release) {
                g2D.drawRect(this.ax, this.ay, this.w, this.h);
            }
        }
        g2D.setColor(BORDER_COLOR);
        g2D.drawRect(0, 0, this.canvasWidth, this.canvasHeight);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.px = this.ax;
        this.py = this.ay;
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.inCross = false;
        if (this.cross.contains(this.mouseX, this.mouseY)) {
            this.inCross = true;
            boolean old = this.fullDisplay;
            boolean bl = this.fullDisplay = !this.fullDisplay;
            if (!this.fullDisplay) {
                this.setSize(this.cross.width, this.cross.height);
            } else {
                this.setSize(this.canvasWidth, this.canvasHeight);
            }
            this.firePropertyChange(FULL_DISPLAY_PROPERTY, old, this.fullDisplay);
            return;
        }
        if (!this.inSelection(this.mouseX, this.mouseY)) {
            this.bx = this.mouseX - this.w / 2;
            if (this.bx < 0) {
                this.bx = 0;
            }
            this.by = this.mouseY - this.h / 2;
            if (this.by < 0) {
                this.by = 0;
            }
        }
        if (this.bx < 0) {
            this.bx = 0;
        }
        if (this.by < 0) {
            this.by = 0;
        }
        this.fullDisplay = true;
        this.locked = this.bover;
        this.bdifx = this.mouseX - this.bx;
        this.bdify = this.mouseY - this.by;
        this.ax = this.bx;
        this.ay = this.by;
        this.release = false;
        this.setCursor(this.mouseX, this.mouseY);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.fullDisplay && !this.inCross) {
            this.locked = false;
            Rectangle r = this.getSelectionRegion();
            if (!this.isSameSelection(r)) {
                this.firePropertyChange(DISPLAY_REGION_PROPERTY, null, r);
            }
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.bdifx = this.mouseX - this.bx;
        this.bdify = this.mouseY - this.by;
        this.ax = this.bx;
        this.ay = this.by;
        this.release = true;
        this.locked = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (!this.inImage()) {
            this.locked = false;
        }
        if (this.locked) {
            this.bx = this.mouseX - this.bdifx;
            this.by = this.mouseY - this.bdify;
        }
        this.locked = true;
        if (this.bx <= 0) {
            this.bx = 1;
        }
        if (this.by <= 0) {
            this.by = 1;
        }
        if (this.bx + this.w >= this.pImage.getWidth()) {
            this.bx = this.pImage.getWidth() - this.w - 1;
        }
        if (this.by + this.h >= this.pImage.getHeight()) {
            this.by = this.pImage.getHeight() - this.h - 1;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setCursor(e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

