/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class ImageCanvas
extends JPanel {
    static final int TOP_LEFT = 0;
    static final int BOTTOM_RIGHT = 1;
    static final Color BACKGROUND = Color.BLACK;
    protected BrowserModel model;
    protected BrowserUI view;
    protected String paintedString;
    protected int height;

    ImageCanvas(BrowserModel model, BrowserUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.setBackground(model.getBackgroundColor());
        this.setDoubleBuffered(true);
        this.setFont(this.getFont().deriveFont(10.0f));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.height = fm.getHeight();
        this.paintedString = null;
    }

    void setPaintedString(int pressedZ, int pressedT) {
        this.paintedString = pressedZ < 0 || pressedT < 0 ? null : "z=" + pressedZ + ", t=" + pressedT;
        this.repaint();
    }

    void paintScaleBar(Graphics2D g2D, int width, int height, JViewport viewPort) {
        if (!this.model.isUnitBar()) {
            return;
        }
        Object value = this.model.getUnitBarValue();
        if (value == null) {
            return;
        }
        value = (String)value + " " + this.model.getUnitBarUnit();
        int size = (int)this.model.getUnitBarSize();
        Rectangle imgRect = new Rectangle(0, 0, width, height);
        Rectangle viewRect = viewPort.getBounds();
        Point p = viewPort.getViewPosition();
        int x = viewPort.getWidth() > width ? 0 : (int)p.getX();
        int y = viewPort.getHeight() > height ? height : (int)p.getY();
        int w = Math.min(x + viewRect.width, width);
        int h = Math.min(y + viewRect.height, height);
        if (imgRect.contains(viewRect)) {
            w = x + viewRect.width;
            h = y + viewRect.height;
        }
        if (imgRect.getWidth() < (double)size) {
            size = 1;
        }
        if (viewRect.width >= size && size > 1) {
            switch (this.view.getBirdEyeViewLocationIndex()) {
                case 1: {
                    ImagePaintingFactory.paintScaleBar(g2D, x + 10, h - 10, size, (String)value, this.model.getUnitBarColor());
                    break;
                }
                default: {
                    ImagePaintingFactory.paintScaleBar(g2D, w - size - 10, h - 10, size, (String)value, this.model.getUnitBarColor());
                }
            }
        }
    }
}

