/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class ImagePaintingFactory {
    public static final Color DEFAULT_BACKGROUND = new Color(200, 200, 200);
    public static final String DEFAULT_BACKGROUND_NAME = "Default background";
    public static final Color UNIT_BAR_COLOR = Color.GRAY;
    public static final String UNIT_BAR_COLOR_NAME = "Gray";
    private static final BasicStroke UNIT_BAR_STROKE = new BasicStroke(2.0f);

    public static void setGraphicRenderingSettings(Graphics2D g2D) {
        ImagePaintingFactory.setGraphicRenderingSettings(g2D, true);
    }

    public static void setGraphicRenderingSettings(Graphics2D g2D, boolean interpolate) {
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (interpolate) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static void paintScaleBar(Graphics2D g2D, int x, int y, int l, String s) {
        ImagePaintingFactory.paintScaleBar(g2D, x, y, l, s, UNIT_BAR_COLOR);
    }

    public static void paintScaleBar(Graphics2D g2D, int x, int y, int l, String s, Color c) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        int hFont = fontMetrics.getHeight() / 3;
        if (c == null) {
            c = UNIT_BAR_COLOR;
        }
        g2D.setColor(c);
        g2D.drawString(s, x + (l - fontMetrics.stringWidth(s)) / 2 + 1, y - hFont);
        g2D.setStroke(UNIT_BAR_STROKE);
        g2D.drawLine(x, y, x + l, y);
    }
}

