/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.FolderData;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class ROIUtil {
    public static boolean haveSameID(List<ROIShape> shapeList) {
        long id = -1L;
        for (ROIShape s : shapeList) {
            if (id == -1L) {
                id = s.getID();
                continue;
            }
            if (id == s.getID()) continue;
            return false;
        }
        return true;
    }

    public static long getSameID(List<ROIShape> shapeList) {
        long id = -1L;
        for (ROIShape s : shapeList) {
            if (id == -1L) {
                id = s.getID();
                continue;
            }
            if (id == s.getID()) continue;
            return -1L;
        }
        return id;
    }

    public static boolean onSeparatePlanes(List<ROIShape> shapeList) {
        HashSet<Coord3D> set = new HashSet<Coord3D>();
        for (ROIShape shape : shapeList) {
            if (set.contains(shape.getCoord3D())) {
                return false;
            }
            set.add(shape.getCoord3D());
        }
        return true;
    }

    public static List<Long> getIDList(List selectedObjects) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Object node : selectedObjects) {
            ROI roi = node instanceof ROI ? (ROI)node : ((ROIShape)node).getROI();
            if (ids.contains(roi.getID())) continue;
            ids.add(roi.getID());
        }
        return ids;
    }

    public static SelectionType getSelectionType(Collection<Object> selection) {
        SelectionType result = null;
        for (Object obj : selection) {
            SelectionType tmp = null;
            if (obj instanceof ROI) {
                tmp = SelectionType.ROIS;
            } else if (obj instanceof ROIShape) {
                tmp = SelectionType.SHAPES;
            } else if (obj instanceof FolderData) {
                tmp = SelectionType.FOLDERS;
            }
            if (result == null) {
                result = tmp;
                continue;
            }
            if (result == tmp) continue;
            return SelectionType.MIXED;
        }
        return result;
    }

    public static String getUUID(Object obj) {
        if (obj instanceof ROI) {
            return "ROI_" + ((ROI)obj).getID();
        }
        if (obj instanceof ROIShape) {
            return "ROIShape_" + ((ROIShape)obj).getID();
        }
        if (obj instanceof FolderData) {
            return "FolderData_" + ((FolderData)obj).getId();
        }
        return "" + obj.hashCode();
    }

    public static void gatherNodes(ROINode node, Collection<ROINode> nodes) {
        nodes.add(node);
        for (MutableTreeTableNode n : node.getChildList()) {
            ROIUtil.gatherNodes((ROINode)n, nodes);
        }
    }

    public static Collection<ROINode> getShapeNodes(ROINode root) {
        ArrayList<ROINode> nodes = new ArrayList<ROINode>();
        ROIUtil.gatherNodes(root, nodes);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ROINode next = (ROINode)((Object)it.next());
            if (next.isShapeNode()) continue;
            it.remove();
        }
        return nodes;
    }

    public static Collection<ROINode> getShapeNodes(long shapeId, ROINode root) {
        Collection<ROINode> nodes = ROIUtil.getShapeNodes(root);
        Iterator<ROINode> it = nodes.iterator();
        while (it.hasNext()) {
            ROINode next = it.next();
            ROIShape shape = (ROIShape)next.getUserObject();
            if (shape.getROIShapeID() == shapeId) continue;
            it.remove();
        }
        return nodes;
    }

    public static void getAllDecendants(ROINode node, Collection<ROINode> nodes) {
        nodes.add(node);
        for (MutableTreeTableNode n : node.getChildList()) {
            ROIUtil.gatherNodes((ROINode)n, nodes);
        }
    }

    public static enum SelectionType {
        ROIS,
        SHAPES,
        FOLDERS,
        MIXED;

    }
}

