/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.PermissionsPane;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class GroupProfile
extends AnnotationUI
implements DocumentListener,
PropertyChangeListener {
    private JTextField namePane;
    private JTextField descriptionPane;
    private PermissionsPane permissionsPane;
    private int level;
    private boolean canEdit;
    private GroupData ref;
    private JButton saveButton;
    private EditorUI view;

    private void initComponents() {
        this.ref = (GroupData)this.model.getRefObject();
        this.namePane = new JTextField();
        this.descriptionPane = new JTextField();
        boolean mayChangePermissions = this.model.isGroupLeader(this.ref) || MetadataViewerAgent.isEditGroup();
        this.permissionsPane = new PermissionsPane(this.ref.getPermissions(), UIUtilities.BACKGROUND_COLOR, this.model.isAdministrator());
        this.level = this.permissionsPane.getPermissions();
        this.permissionsPane.allowDowngrade(!mayChangePermissions);
        this.permissionsPane.setBorder(BorderFactory.createTitledBorder("Permissions"));
        this.permissionsPane.addPropertyChangeListener(this);
        this.namePane.setText(this.ref.getName());
        this.descriptionPane.setText(this.ref.getDescription());
        this.canEdit = mayChangePermissions && !this.model.isSystemGroup(this.ref.getId());
        this.namePane.setEditable(this.canEdit);
        this.namePane.setEnabled(this.canEdit);
        this.descriptionPane.setEditable(this.canEdit);
        this.permissionsPane.setEnabled(this.canEdit);
        if (this.canEdit) {
            this.namePane.getDocument().addDocumentListener(this);
            this.descriptionPane.getDocument().addDocumentListener(this);
        }
        this.saveButton = new JButton("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupProfile.this.view.saveData(true);
            }
        });
    }

    private JPanel buildContentPanel() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        JComponent label = EditorUtil.getLabel("Name", true);
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.namePane, c);
        c.gridx = 0;
        ++c.gridy;
        label = UIUtilities.setTextFont("Description");
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.descriptionPane, c);
        c.gridx = 0;
        ++c.gridy;
        label = UIUtilities.setTextFont("* indicates the required fields.", 2);
        label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
        c.weightx = 0.0;
        content.add((Component)label, c);
        return content;
    }

    private JPanel buildOwnersPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        if (this.model.getRefObject() instanceof GroupData) {
            GroupData group = (GroupData)this.model.getRefObject();
            Set<ExperimenterData> leaders = group.getLeaders();
            if (leaders == null || leaders.size() == 0) {
                return p;
            }
            for (ExperimenterData exp : leaders) {
                p.add(new JLabel(EditorUtil.formatExperimenter(exp)));
            }
        } else {
            return p;
        }
        JPanel content = UIUtilities.buildComponentPanel(p);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createTitledBorder("Owners"));
        content.add(p);
        return content;
    }

    GroupProfile(EditorModel model, EditorUI view) {
        super(model);
        if (view == null) {
            throw new IllegalArgumentException("No view");
        }
        this.view = view;
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    AdminObject getAdminObject() {
        if (!this.canEdit) {
            return null;
        }
        GroupData data = (GroupData)this.model.getRefObject();
        String v = this.namePane.getText();
        v = v.trim();
        if (!data.getName().equals(v)) {
            if (this.model.doesGroupExist(data, v)) {
                UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Update Group", "A group with the same name already exists.");
                return null;
            }
            data.setName(v);
        }
        this.saveButton.setEnabled(false);
        v = this.descriptionPane.getText();
        v = v.trim();
        String description = data.getDescription();
        if (description == null) {
            description = "";
        }
        if (!description.equals(v)) {
            data.setDescription(v);
        }
        AdminObject o = new AdminObject(data, null, 2);
        if (this.level != this.permissionsPane.getPermissions()) {
            o.setPermissions(this.permissionsPane.getPermissions());
        }
        return o;
    }

    @Override
    protected void buildUI() {
        this.removeAll();
        this.initComponents();
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        p.add((Component)this.buildContentPanel(), c);
        ++c.gridy;
        p.add((Component)this.permissionsPane, c);
        ++c.gridy;
        p.add((Component)this.buildOwnersPane(), c);
        ++c.gridy;
        JPanel buttonPanel = UIUtilities.buildComponentPanel(this.saveButton);
        buttonPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add((Component)buttonPanel, c);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)p, "North");
    }

    @Override
    protected void clearData(Object oldObject) {
        if (this.namePane != null) {
            this.namePane.setText("");
        }
        if (this.descriptionPane != null) {
            this.descriptionPane.setText("");
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void clearDisplay() {
    }

    @Override
    protected List<Object> getAnnotationToRemove() {
        return new ArrayList<Object>();
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected String getComponentTitle() {
        return "Group";
    }

    @Override
    protected boolean hasDataToSave() {
        boolean b;
        if (this.saveButton != null) {
            this.saveButton.setEnabled(false);
        }
        if (this.namePane == null) {
            return false;
        }
        String v = this.namePane.getText();
        if ((v = v.trim()).length() == 0) {
            this.saveButton.setEnabled(false);
            return false;
        }
        if (!this.ref.getName().equals(v)) {
            if (this.saveButton != null) {
                this.saveButton.setEnabled(true);
            }
            return true;
        }
        v = this.descriptionPane.getText();
        v = v.trim();
        String description = this.ref.getDescription();
        if (description == null) {
            description = "";
        }
        if (!description.equals(v)) {
            if (this.saveButton != null) {
                this.saveButton.setEnabled(true);
            }
            return true;
        }
        boolean bl = b = this.level != this.permissionsPane.getPermissions();
        if (this.saveButton != null) {
            this.saveButton.setEnabled(b);
        }
        return b;
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("permissionsChange".equals(name)) {
            this.firePropertyChange("save", (Object)false, (Object)true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

