/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PreviewToolBar
extends JPanel {
    static final int SPACE = 3;
    private static final String PREVIEW = "Live Update";
    private static final String PREVIEW_DESCRIPTION = "Update the rendering settings immediately. Not available for large images";
    private RendererControl control;
    private RendererModel model;
    private JLabel selectedPlane;
    private JToggleButton preview;

    private void initComponents() {
        this.selectedPlane = new JLabel();
        Font font = this.selectedPlane.getFont();
        Font newFont = font.deriveFont(font.getStyle(), font.getSize() - 2);
        this.selectedPlane.setFont(newFont);
        this.setSelectedPlane();
        this.preview = new JCheckBox(PREVIEW);
        this.preview.setBackground(UIUtilities.BACKGROUND);
        this.preview.setEnabled(!this.model.isBigImage());
        this.preview.setToolTipText(PREVIEW_DESCRIPTION);
        this.preview.setFont(newFont);
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.selectedPlane);
        this.add(Box.createHorizontalGlue());
        this.add(this.preview);
    }

    PreviewToolBar(RendererControl control, RendererModel model) {
        this.control = control;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedPlane() {
        String s = "Z:" + (this.model.getDefaultZ() + 1) + "/" + this.model.getMaxZ();
        s = s + " T:" + (this.model.getRealSelectedT() + 1) + "/" + this.model.getRealT();
        if (this.model.isLifetimeImage()) {
            s = s + " t:" + (this.model.getSelectedBin() + 1);
            s = s + "/" + this.model.getMaxLifetimeBin();
        }
        this.selectedPlane.setText(s);
    }

    boolean isLiveUpdate() {
        return this.preview.isSelected();
    }
}

