/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class FilesChecker
extends DataBrowserLoader {
    private CallHandle handle;
    private List<TreeImageNode> nodes;
    private Map<File, TreeImageNode> map;

    public FilesChecker(Browser viewer, SecurityContext ctx, List<TreeImageNode> nodes) {
        super(viewer, ctx);
        if (nodes == null) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.nodes = nodes;
    }

    @Override
    public void load() {
        ArrayList<File> list = new ArrayList<File>();
        this.map = new HashMap<File, TreeImageNode>();
        for (TreeImageNode node : this.nodes) {
            Object o = node.getUserObject();
            if (!(o instanceof File)) continue;
            this.map.put((File)o, node);
            list.add((File)o);
        }
        this.handle = this.dmView.checkFileFormat(list, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        Map m = (Map)result;
        List l = (List)m.get(false);
        if (l != null && l.size() > 0) {
            for (File f : l) {
                this.map.get(f).setSelectable(false);
            }
            this.viewer.getUI().repaint();
        }
    }
}

