/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.treeviewer.util.DataMenuItem;
import org.openmicroscopy.shoola.util.ui.SelectableMenu;

public class GroupItem
extends SelectableMenu
implements PropertyChangeListener {
    public static final String USER_SELECTION_PROPERTY = "userSelection";
    public static final String ALL_GROUPS = "All Groups";
    public static final String ALL_GROUPS_SELECTION_PROPERTY = "allGroupsSelection";
    public static final String ALL_GROUPS_DESELECTION_PROPERTY = "allGroupsDeselection";
    public static final String ALL_USERS_SELECTION_PROPERTY = "allUsersSelection";
    private GroupData group;
    private List<DataMenuItem> usersItem;
    private long userID;

    public GroupItem(GroupData group, boolean selected, boolean selectable) {
        super(selected, group.getName(), selectable);
        this.group = group;
        this.addPropertyChangeListener(this);
    }

    public GroupItem(GroupData group, boolean selected) {
        super(selected, group.getName(), true);
        this.group = group;
        this.addPropertyChangeListener(this);
    }

    public GroupItem(boolean selected) {
        super(selected, ALL_GROUPS, true);
        this.addPropertyChangeListener(this);
    }

    public void setUsersItem(List<DataMenuItem> usersItem) {
        this.usersItem = usersItem;
    }

    public void setUserID(long userID) {
        this.userID = userID;
    }

    public GroupData getGroup() {
        return this.group;
    }

    public List<ExperimenterData> getSeletectedUsers() {
        ArrayList<ExperimenterData> users = new ArrayList<ExperimenterData>();
        for (DataMenuItem item : this.usersItem) {
            Object ho = item.getDataObject();
            if (!item.isChecked() || !(ho instanceof ExperimenterData)) continue;
            users.add((ExperimenterData)ho);
        }
        return users;
    }

    public void setDisplay(boolean enabled) {
        for (DataMenuItem item : this.usersItem) {
            item.setEnabled(enabled);
            if (!enabled) {
                item.setChecked(true);
                continue;
            }
            Object ho = item.getDataObject();
            if (ho instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)ho;
                item.setChecked(exp.getId() == this.userID);
                continue;
            }
            item.setChecked(false);
        }
    }

    public void selectUsers(boolean all, boolean select) {
        block3: {
            block4: {
                if (!all) break block4;
                for (DataMenuItem data : this.usersItem) {
                    Object ho = data.getDataObject();
                    if (ho instanceof ExperimenterData && data.isEnabled()) {
                        data.setChecked(select);
                        long id = ((ExperimenterData)ho).getId();
                        if (id != this.userID) continue;
                        data.setChecked(true);
                        continue;
                    }
                    if (!(ho instanceof String)) continue;
                    data.removePropertyChangeListener(this);
                    data.setChecked(select);
                    data.addPropertyChangeListener(this);
                }
                break block3;
            }
            List<ExperimenterData> l = this.getSeletectedUsers();
            if (!CollectionUtils.isEmpty(l)) break block3;
            for (DataMenuItem data : this.usersItem) {
                long id;
                Object ho = data.getDataObject();
                if (!(ho instanceof ExperimenterData) || !data.isEnabled() || (id = ((ExperimenterData)ho).getId()) != this.userID) continue;
                data.setChecked(true);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (DataMenuItem.ITEM_SELECTED_PROPERTY.equals(name)) {
            List<ExperimenterData> l;
            DataMenuItem item2 = (DataMenuItem)evt.getNewValue();
            Object ho = item2.getDataObject();
            if (ho instanceof String) {
                if (DataMenuItem.ALL_USERS_TEXT.equals(item2.getRefString())) {
                    this.selectUsers(true, item2.isChecked());
                    Iterator<DataMenuItem> i = this.usersItem.iterator();
                    boolean b = item2.isChecked();
                    while (i.hasNext()) {
                        item2 = i.next();
                        ho = item2.getDataObject();
                        if (!(ho instanceof ExperimenterData) || !item2.isEnabled()) continue;
                        ExperimenterData exp = (ExperimenterData)ho;
                        if (b) {
                            item2.setChecked(b);
                            continue;
                        }
                        if (exp.getId() == this.userID) continue;
                        item2.setChecked(b);
                    }
                }
            } else {
                l = this.getSeletectedUsers();
                boolean all = l.size() == this.usersItem.size() - 1;
                for (DataMenuItem item2 : this.usersItem) {
                    ho = item2.getDataObject();
                    if (!(ho instanceof String) || !DataMenuItem.ALL_USERS_TEXT.equals(item2.getRefString())) continue;
                    item2.removePropertyChangeListener(this);
                    item2.setChecked(all);
                    item2.addPropertyChangeListener(this);
                }
            }
            l = this.getSeletectedUsers();
            if (this.getGroup() != null) {
                if (this.isSelectable()) {
                    this.setMenuSelected(CollectionUtils.isNotEmpty(l), false);
                }
                this.firePropertyChange(USER_SELECTION_PROPERTY, null, this);
            } else {
                boolean selected = item2.isChecked();
                if (!selected && this.isMenuSelected()) {
                    this.setMenuSelected(false, false);
                } else if (selected && !this.isMenuSelected()) {
                    this.setMenuSelected(true, false);
                }
                this.firePropertyChange(ALL_USERS_SELECTION_PROPERTY, null, (Object)selected);
            }
        } else if (SelectableMenu.GROUP_SELECTION_PROPERTY.equals(name)) {
            GroupItem item = (GroupItem)evt.getNewValue();
            if (item != this) {
                return;
            }
            GroupData group = item.getGroup();
            if (group == null && ALL_GROUPS.equals(item.getText())) {
                if (item.isMenuSelected()) {
                    this.firePropertyChange(ALL_GROUPS_SELECTION_PROPERTY, null, this);
                } else {
                    this.firePropertyChange(ALL_GROUPS_DESELECTION_PROPERTY, null, this);
                }
                return;
            }
            if (!item.isMenuSelected()) {
                this.firePropertyChange(USER_SELECTION_PROPERTY, null, this);
            } else {
                this.selectUsers(false, true);
                this.firePropertyChange(USER_SELECTION_PROPERTY, null, this);
            }
        }
    }
}

