/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FileLoadingComponent
extends JPanel
implements ActionListener {
    static final String CANCEL_PROPERTY = "cancel";
    static final String REMOVE_PROPERTY = "remove";
    private static final int CANCEL = 0;
    private static final int REMOVE = 1;
    private static final String DONE = "Downloaded in: ";
    private static final String CANCEL_LOADING = "Cancelled";
    private JButton cancelButton;
    private JButton removeButton;
    private long fileID;
    private String fileName;
    private String directory;
    private IconManager icons;
    private JPanel barPane;
    private JPanel textPane;
    private JToolBar toolBar;

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.cancelButton.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.cancelButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.setActionCommand("1");
        this.removeButton.addActionListener(this);
        this.removeButton.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.removeButton);
        double[][] tl = new double[][]{{-2.0, -1.0, -2.0}, {-2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.barPane = new JPanel();
        this.barPane.setOpaque(false);
        this.barPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        double[][] size = new double[][]{{-1.0}, {-2.0, -2.0}};
        this.barPane.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(null);
        this.textPane = UIUtilities.buildComponentPanel(this.barPane);
    }

    private void buildGUI(boolean init, String message) {
        this.removeAll();
        this.barPane.removeAll();
        this.add((Component)new JLabel(this.icons.getIcon(13)), "0, 0");
        this.toolBar.removeAll();
        this.cancelButton.setVisible(false);
        if (init) {
            this.barPane.add((Component)new JLabel(this.fileName), "0, 0, CENTER, CENTER");
            JProgressBar bar = new JProgressBar();
            bar.setIndeterminate(true);
            this.cancelButton.setVisible(true);
            bar.setBackground(this.barPane.getBackground());
            this.barPane.add((Component)bar, "0, 1");
            this.toolBar.add(this.cancelButton);
            this.add((Component)this.toolBar, "2, 0");
        } else {
            this.barPane.add((Component)new JLabel(this.fileName), "0, 0, CENTER, CENTER");
            this.barPane.add((Component)UIUtilities.setTextFont(message, 2, 10), "0, 1, CENTER, CENTER");
            this.toolBar.add(this.removeButton);
            this.add((Component)this.toolBar, "2, 0");
        }
        this.add((Component)this.textPane, "1, 0");
    }

    FileLoadingComponent(String directory, String fileName, long fileID, IconManager icons) {
        if (icons == null) {
            throw new IllegalArgumentException("No icons manager specified.");
        }
        this.fileName = fileName;
        this.directory = directory;
        this.fileID = fileID;
        this.icons = icons;
        this.initComponents();
        this.buildGUI(true, null);
    }

    boolean isOngoingActivity() {
        return this.cancelButton.isVisible();
    }

    void setStatus(int percent) {
        if (percent == 0) {
            this.buildGUI(false, DONE + this.directory);
        } else if (percent == -1) {
            this.buildGUI(false, CANCEL_LOADING);
        }
        this.revalidate();
        this.repaint();
    }

    long getFileID() {
        return this.fileID;
    }

    String getAbsolutePath() {
        return this.directory + this.fileName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(CANCEL_PROPERTY, (Object)-1, this.getAbsolutePath());
                break;
            }
            case 1: {
                this.firePropertyChange(REMOVE_PROPERTY, (Object)-1, this.getAbsolutePath());
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.barPane != null) {
            this.barPane.setBackground(color);
        }
        if (this.textPane != null) {
            this.textPane.setBackground(color);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setBackground(color);
        }
        if (this.removeButton != null) {
            this.removeButton.setBackground(color);
        }
        if (this.toolBar != null) {
            this.toolBar.setBackground(color);
        }
    }
}

