/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PopupHint {
    private static final int DEFAULT_SHOW_TIME = 3000;
    private static final int INSETS = 3;
    private JComponent component;
    private JPopupMenu popup;
    private Timer hideTimer;
    private JLabel text;

    public PopupHint(JComponent component, String message) {
        this(component, message, 3000);
    }

    public PopupHint(JComponent component, String message, int showTime) {
        this.component = component;
        Color c = UIUtilities.TOOLTIP_COLOR;
        FontUIResource f = (FontUIResource)UIManager.get("ToolTip.font");
        this.popup = new JPopupMenu();
        this.popup.setLayout(new BoxLayout(this.popup, 3));
        this.popup.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.popup.setBackground(c);
        this.popup.setFont(f);
        this.text = new JLabel(message);
        this.text.setBackground(c);
        this.text.setFont(f);
        this.popup.add(this.text);
        this.hideTimer = new Timer(showTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupHint.this.popup.setVisible(false);
                PopupHint.this.hideTimer.stop();
            }
        });
    }

    public void show() {
        if (!this.popup.isVisible()) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension textDim = this.text.getPreferredSize();
            if (this.component.isShowing()) {
                int xOffset = 0;
                int xScreen = this.component.getLocationOnScreen().x + textDim.width;
                if (xScreen > screenSize.width - 5) {
                    xOffset = xScreen - screenSize.width + 5;
                }
                int x = this.component.getLocation().x - xOffset;
                int y = this.component.getLocation().y - textDim.height - 5;
                this.popup.show(this.component, x, y);
            } else {
                UIUtilities.centerAndShow(this.popup);
            }
            this.hideTimer.start();
        } else {
            this.hideTimer.restart();
        }
    }
}

