/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSlider;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;

class RGBSliderUI
extends JPanel {
    private ColourSlider redSlider;
    private ColourSlider greenSlider;
    private ColourSlider blueSlider;
    private ColourSlider alphaSlider;
    private ChangeListener redChangeListener;
    private ChangeListener greenChangeListener;
    private ChangeListener blueChangeListener;
    private ChangeListener alphaChangeListener;
    private ActionListener redTextboxActionListener;
    private ActionListener greenTextboxActionListener;
    private ActionListener blueTextboxActionListener;
    private ActionListener alphaTextboxActionListener;
    private boolean active;
    private JTextField redTextbox;
    private JTextField greenTextbox;
    private JTextField blueTextbox;
    private JTextField alphaTextbox;
    private JLabel redLabel;
    private JLabel greenLabel;
    private JLabel blueLabel;
    private JLabel alphaLabel;
    private GridBagLayout layout;
    private RGBControl control;

    RGBSliderUI(RGBControl c) {
        if (c == null) {
            throw new NullPointerException("No control.");
        }
        this.control = c;
        this.createUI();
        this.active = false;
    }

    void setActive(boolean act) {
        this.active = act;
    }

    void createRedSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(0, s1.getGreen(), s1.getBlue(), 255);
        Color e = new Color(255, s1.getGreen(), s1.getBlue(), 255);
        this.redSlider = new ColourSlider(0, 255, s, e);
        this.redSlider.setValue((int)((double)this.control.getRed() * 255.0));
        this.redChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                RGBSliderUI.this.control.setRed((float)src.getValue() / 255.0f);
            }
        };
        this.redSlider.addChangeListener(this.redChangeListener);
    }

    void createGreenSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), 0, s1.getBlue(), 255);
        Color e1 = this.control.getColour();
        Color e = new Color(e1.getRed(), 255, s1.getBlue(), 255);
        this.greenSlider = new ColourSlider(0, 255, s, e);
        this.greenSlider.setValue((int)((double)this.control.getGreen() * 255.0));
        this.greenChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                RGBSliderUI.this.control.setGreen((float)src.getValue() / 255.0f);
            }
        };
        this.greenSlider.addChangeListener(this.greenChangeListener);
    }

    void createBlueSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), 0, 255);
        Color e1 = this.control.getColour();
        Color e = new Color(e1.getRed(), s1.getGreen(), 255, 255);
        this.blueSlider = new ColourSlider(0, 255, s, e);
        this.blueSlider.setValue((int)((double)this.control.getBlue() * 255.0));
        this.blueChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                RGBSliderUI.this.control.setBlue((float)src.getValue() / 255.0f);
            }
        };
        this.blueSlider.addChangeListener(this.blueChangeListener);
    }

    void createAlphaSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 0);
        Color e1 = this.control.getColour();
        Color e = new Color(e1.getRed(), s1.getGreen(), s1.getBlue(), 255);
        this.alphaSlider = new ColourSlider(0, 255, s, e);
        this.alphaSlider.setValue((int)((double)this.control.getAlpha() * 255.0));
        this.alphaChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                RGBSliderUI.this.control.setAlpha((float)src.getValue() / 255.0f);
            }
        };
        this.alphaSlider.addChangeListener(this.alphaChangeListener);
    }

    void createRedTextbox() {
        this.redTextbox = new JTextField("" + (int)(this.control.getRed() * 255.0f));
        this.redTextbox.setColumns(2);
        this.redTextboxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        RGBSliderUI.this.control.setRed((float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        RGBSliderUI.this.redTextbox.setText("" + (int)(RGBSliderUI.this.control.getRed() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    RGBSliderUI.this.redTextbox.setText("" + (int)(RGBSliderUI.this.control.getRed() * 255.0f));
                }
            }
        };
        this.redTextbox.addActionListener(this.redTextboxActionListener);
    }

    void createGreenTextbox() {
        this.greenTextbox = new JTextField("" + (int)(this.control.getGreen() * 255.0f));
        this.greenTextbox.setColumns(2);
        this.greenTextboxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        RGBSliderUI.this.control.setGreen((float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        RGBSliderUI.this.greenTextbox.setText("" + (int)(RGBSliderUI.this.control.getGreen() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    RGBSliderUI.this.greenTextbox.setText("" + (int)(RGBSliderUI.this.control.getGreen() * 255.0f));
                }
            }
        };
        this.greenTextbox.addActionListener(this.greenTextboxActionListener);
    }

    void createBlueTextbox() {
        this.blueTextbox = new JTextField("" + (int)(this.control.getBlue() * 255.0f));
        this.blueTextbox.setColumns(2);
        this.blueTextboxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        RGBSliderUI.this.control.setBlue((float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        RGBSliderUI.this.blueTextbox.setText("" + (int)(RGBSliderUI.this.control.getBlue() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    RGBSliderUI.this.blueTextbox.setText("" + (int)(RGBSliderUI.this.control.getBlue() * 255.0f));
                }
            }
        };
        this.blueTextbox.addActionListener(this.blueTextboxActionListener);
    }

    void createAlphaTextbox() {
        this.alphaTextbox = new JTextField("" + (int)(this.control.getAlpha() * 255.0f));
        this.alphaTextbox.setColumns(2);
        this.alphaTextboxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        RGBSliderUI.this.control.setAlpha((float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        RGBSliderUI.this.alphaTextbox.setText("" + (int)(RGBSliderUI.this.control.getAlpha() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    RGBSliderUI.this.alphaTextbox.setText("" + (int)(RGBSliderUI.this.control.getAlpha() * 255.0f));
                }
            }
        };
        this.alphaTextbox.addActionListener(this.alphaTextboxActionListener);
    }

    void createLabels() {
        this.redLabel = new JLabel("Red");
        this.greenLabel = new JLabel("Green");
        this.blueLabel = new JLabel("Blue");
        this.alphaLabel = new JLabel("Alpha");
    }

    void layoutComponents() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 80.0;
        gbc.weighty = 5.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.redLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.redSlider, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 20.0;
        this.add((Component)this.redTextbox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 80.0;
        this.add((Component)this.greenLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.greenSlider, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 20.0;
        this.add((Component)this.greenTextbox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 80.0;
        this.add((Component)this.blueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        this.add((Component)this.blueSlider, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 20.0;
        this.add((Component)this.blueTextbox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 80.0;
        this.add((Component)this.alphaLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        this.add((Component)this.alphaSlider, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 20.0;
        this.add((Component)this.alphaTextbox, gbc);
    }

    void createUI() {
        this.createRedSlider();
        this.createGreenSlider();
        this.createBlueSlider();
        this.createAlphaSlider();
        this.createRedTextbox();
        this.createGreenTextbox();
        this.createBlueTextbox();
        this.createAlphaTextbox();
        this.createLabels();
        this.layoutComponents();
    }

    void updateRedSlider() {
        this.redSlider.setValue((int)(this.control.getRed() * 255.0f));
        Color s1 = this.control.getColour();
        Color s = new Color(0, s1.getGreen(), s1.getBlue(), 255);
        Color e = new Color(255, s1.getGreen(), s1.getBlue(), 255);
        this.redSlider.setRGBStart(s);
        this.redSlider.setRGBEnd(e);
    }

    void updateGreenSlider() {
        this.greenSlider.setValue((int)(this.control.getGreen() * 255.0f));
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), 0, s1.getBlue(), 255);
        Color e = new Color(s1.getRed(), 255, s1.getBlue(), 255);
        this.greenSlider.setRGBStart(s);
        this.greenSlider.setRGBEnd(e);
    }

    void updateBlueSlider() {
        this.blueSlider.setValue((int)(this.control.getBlue() * 255.0f));
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), 0, 255);
        Color e = new Color(s1.getRed(), s1.getGreen(), 255, 255);
        this.blueSlider.setRGBStart(s);
        this.blueSlider.setRGBEnd(e);
    }

    void updateAlphaSlider() {
        this.alphaSlider.setValue((int)(this.control.getAlpha() * 255.0f));
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 0);
        Color e = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 255);
        this.alphaSlider.setRGBStart(s);
        this.alphaSlider.setRGBEnd(e);
    }

    void updateSliders() {
        this.updateRedSlider();
        this.updateBlueSlider();
        this.updateGreenSlider();
        this.updateAlphaSlider();
    }

    void updateTextboxes() {
        this.redTextbox.setText("" + (int)(this.control.getRed() * 255.0f));
        this.greenTextbox.setText("" + (int)(this.control.getGreen() * 255.0f));
        this.blueTextbox.setText("" + (int)(this.control.getBlue() * 255.0f));
        this.alphaTextbox.setText("" + (int)(this.control.getAlpha() * 255.0f));
    }

    void refresh() {
        if (!this.active) {
            return;
        }
        this.removeListeners();
        this.updateSliders();
        this.updateTextboxes();
        this.addListeners();
        this.repaint();
    }

    void addListeners() {
        this.redSlider.addChangeListener(this.redChangeListener);
        this.greenSlider.addChangeListener(this.greenChangeListener);
        this.blueSlider.addChangeListener(this.blueChangeListener);
        this.alphaSlider.addChangeListener(this.alphaChangeListener);
        this.redTextbox.addActionListener(this.redTextboxActionListener);
        this.greenTextbox.addActionListener(this.greenTextboxActionListener);
        this.blueTextbox.addActionListener(this.blueTextboxActionListener);
        this.alphaTextbox.addActionListener(this.alphaTextboxActionListener);
    }

    void removeListeners() {
        this.redSlider.removeChangeListener(this.redChangeListener);
        this.greenSlider.removeChangeListener(this.greenChangeListener);
        this.blueSlider.removeChangeListener(this.blueChangeListener);
        this.alphaSlider.removeChangeListener(this.alphaChangeListener);
        this.redTextbox.removeActionListener(this.redTextboxActionListener);
        this.greenTextbox.removeActionListener(this.greenTextboxActionListener);
        this.blueTextbox.removeActionListener(this.blueTextboxActionListener);
        this.alphaTextbox.removeActionListener(this.alphaTextboxActionListener);
    }
}

