/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Name;
import ome.conditions.InternalException;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;

public class LdapConfig {
    private final Map<String, String> groupMapping;
    private final Map<String, String> userMapping;
    private final HardcodedFilter userFilter;
    private final HardcodedFilter groupFilter;
    private final String base;
    private final String newUserGroup;
    private final String newUserGroupOwner;
    private final boolean enabled;
    private final boolean syncOnLogin;

    public LdapConfig(boolean enabled, String newUserGroup, String userFilter, String groupFilter, String userMapping, String groupMapping) {
        this(enabled, newUserGroup, userFilter, groupFilter, userMapping, groupMapping, false, null);
    }

    public LdapConfig(boolean enabled, String newUserGroup, String userFilter, String groupFilter, String userMapping, String groupMapping, boolean syncOnLogin) {
        this(enabled, newUserGroup, userFilter, groupFilter, userMapping, groupMapping, syncOnLogin, null);
    }

    public LdapConfig(boolean enabled, String newUserGroup, String userFilter, String groupFilter, String userMapping, String groupMapping, boolean syncOnLogin, String base) {
        this(enabled, newUserGroup, userFilter, groupFilter, userMapping, groupMapping, syncOnLogin, base, null);
    }

    public LdapConfig(boolean enabled, String newUserGroup, String userFilter, String groupFilter, String userMapping, String groupMapping, boolean syncOnLogin, String base, String newUserGroupOwner) {
        this.enabled = enabled;
        this.newUserGroup = newUserGroup;
        this.userFilter = new HardcodedFilter(userFilter);
        this.groupFilter = new HardcodedFilter(groupFilter);
        this.userMapping = this.parse(userMapping);
        this.groupMapping = this.parse(groupMapping);
        this.syncOnLogin = syncOnLogin;
        this.base = base;
        this.newUserGroupOwner = newUserGroupOwner;
    }

    public Filter usernameFilter(String username) {
        String attributeKey = this.getUserAttribute("omeName");
        AndFilter filter = new AndFilter();
        filter.and(this.getUserFilter());
        filter.and((Filter)new EqualsFilter(attributeKey, username));
        return filter;
    }

    public Filter groupnameFilter(String groupname) {
        String attributeKey = this.getGroupAttribute("name");
        AndFilter filter = new AndFilter();
        filter.and(this.getGroupFilter());
        filter.and((Filter)new EqualsFilter(attributeKey, groupname));
        return filter;
    }

    public DistinguishedName relativeDN(String fullDNString) {
        DistinguishedName full = new DistinguishedName(fullDNString);
        DistinguishedName base = new DistinguishedName(this.base);
        if (this.base.trim().length() == 0) {
            return full;
        }
        if (base.equals((Object)full)) {
            return new DistinguishedName("");
        }
        if (!full.startsWith((Name)base)) {
            throw new InternalException(String.format("Full DN (%s) does not start with base DN (%s)", full, base));
        }
        full.removeFirst((Name)base);
        return full;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSyncOnLogin() {
        return this.syncOnLogin;
    }

    public String getNewUserGroup() {
        return this.newUserGroup;
    }

    public String getNewUserGroupOwner() {
        return this.newUserGroupOwner;
    }

    public Filter getUserFilter() {
        return this.userFilter;
    }

    public Filter getGroupFilter() {
        return this.groupFilter;
    }

    public String getUserAttribute(String key) {
        return this.userMapping.get(key);
    }

    public String getGroupAttribute(String key) {
        return this.groupMapping.get(key);
    }

    protected Map<String, String> parse(String mapping) {
        HashMap<String, String> rv = new HashMap<String, String>();
        String[] mappings = mapping.split("[\\n\\s;:,]+");
        for (int i = 0; i < mappings.length; ++i) {
            String[] parts = mappings[i].split("=", 2);
            rv.put(parts[0], parts.length < 2 ? null : parts[1]);
        }
        return rv;
    }
}

