/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scripts;

import ome.model.core.OriginalFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;

public class ScriptFileType {
    private final String pattern;
    private final String mimetype;
    private final String launcher;
    private final String process;

    public ScriptFileType(String pattern, String mimetype) {
        this(pattern, mimetype, "", "");
    }

    public ScriptFileType(String pattern, String mimetype, String launcher, String process) {
        this.pattern = pattern;
        this.mimetype = mimetype;
        this.launcher = launcher;
        this.process = process;
    }

    public boolean isInert() {
        return StringUtils.isBlank((String)this.launcher) && StringUtils.isBlank((String)this.process);
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public IOFileFilter getFileFilter() {
        return new WildcardFileFilter(this.pattern);
    }

    public String getLauncher() {
        return this.launcher;
    }

    public String getProcess() {
        return this.process;
    }

    public boolean setMimetype(OriginalFile ofile) {
        if (FilenameUtils.wildcardMatch((String)ofile.getName(), (String)this.pattern)) {
            ofile.setMimetype(this.mimetype);
            return true;
        }
        return false;
    }
}

