/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import loci.common.FileHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;

public class TiffJAIReader
extends BIFormatReader {
    private static final String NO_JAI_MSG = "Java Advanced Imaging (JAI) is required to read some TIFF files. Please install JAI from https://jai.dev.java.net/";
    protected ReflectedUniverse r;

    public TiffJAIReader() {
        super("Tagged Image File Format", TiffReader.TIFF_SUFFIXES);
        this.domains = new String[]{"Graphics"};
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)-1, (int)x, (int)y, (int)w, (int)h);
        BufferedImage img = this.openBufferedImage(no);
        return AWTImageTools.getSubimage(img, this.isLittleEndian(), x, y, w, h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initFile(String id) throws FormatException, IOException {
        int numPages;
        LOGGER.info("Checking for JAI");
        try {
            this.r = new ReflectedUniverse();
            this.r.exec("import javax.media.jai.NullOpImage");
            this.r.exec("import javax.media.jai.OpImage");
            this.r.exec("import com.sun.media.jai.codec.FileSeekableStream");
            this.r.exec("import com.sun.media.jai.codec.ImageDecoder");
            this.r.exec("import com.sun.media.jai.codec.ImageCodec");
        }
        catch (ReflectException exc) {
            throw new MissingLibraryException(NO_JAI_MSG, (Throwable)exc);
        }
        super.initFile(id);
        LOGGER.info("Reading movie dimensions");
        IRandomAccess ira = Location.getMappedFile(id);
        if (ira != null) {
            if (!(ira instanceof FileHandle)) throw new FormatException("Unsupported handle type" + ira.getClass().getName());
            FileHandle fh = (FileHandle)ira;
            this.r.setVar("file", fh.getRandomAccessFile());
        } else {
            String mapId = Location.getMappedId(id);
            File file = new File(mapId);
            if (!file.exists()) throw new FileNotFoundException(id);
            this.r.setVar("file", file);
        }
        this.r.setVar("tiff", "tiff");
        this.r.setVar("param", null);
        try {
            this.r.exec("s = new FileSeekableStream(file)");
            this.r.exec("dec = ImageCodec.createImageDecoder(tiff, s, param)");
            numPages = (Integer)this.r.exec("dec.getNumPages()");
        }
        catch (ReflectException exc) {
            throw new FormatException((Throwable)exc);
        }
        if (numPages < 0) {
            throw new FormatException("Invalid page count: " + numPages);
        }
        BufferedImage img = this.openBufferedImage(0);
        if (img == null) {
            throw new FormatException("Invalid image stream");
        }
        LOGGER.info("Populating metadata");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.imageCount = numPages;
        m.sizeX = img.getWidth();
        m.sizeY = img.getHeight();
        m.sizeZ = 1;
        m.sizeC = img.getSampleModel().getNumBands();
        m.sizeT = numPages;
        m.rgb = m.sizeC > 1;
        m.dimensionOrder = "XYCZT";
        m.pixelType = AWTImageTools.getPixelType(img);
        m.interleaved = true;
        m.littleEndian = false;
        m.metadataComplete = true;
        m.indexed = false;
        m.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    protected BufferedImage openBufferedImage(int no) throws FormatException {
        RenderedImage img;
        this.r.setVar("no", no);
        try {
            this.r.exec("img = dec.decodeAsRenderedImage(no)");
            img = (RenderedImage)this.r.exec("new NullOpImage(img, null, OpImage.OP_IO_BOUND, null)");
        }
        catch (ReflectException exc) {
            throw new FormatException((Throwable)exc);
        }
        return AWTImageTools.convertRenderedImage(img);
    }
}

