/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.ObjectAdapter;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.AbstractRepositoryI;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import omero.ServerError;
import omero.ValidationException;
import omero.model.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryRepositoryI
extends AbstractRepositoryI {
    private static final Logger log = LoggerFactory.getLogger(TemporaryRepositoryI.class);

    public TemporaryRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, Principal p, PublicRepositoryI servant) {
        super(oa, reg, ex, p, System.getProperty("java.io.tmpdir"), new ReadOnlyStatus(false, false), servant);
    }

    @Override
    public String getFilePath(OriginalFile file, Current __current) throws ServerError {
        String repo = this.getFileRepo(file);
        if (repo == null || !repo.equals(this.getRepoUuid())) {
            String msg = String.format("%s (in %s) does not belong to this repository: %s", file.getId().getValue(), repo, this.getRepoUuid());
            throw new ValidationException(null, null, msg);
        }
        return file.getPath().getValue();
    }
}

