/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ACM;
import Ice.ACMClose;
import Ice.ACMHeartbeat;
import Ice.ConnectionI;
import Ice.IntOptional;
import Ice.Optional;
import IceInternal.ACMConfig;
import IceInternal.ACMMonitor;
import IceInternal.ConnectionACMMonitor;
import IceInternal.Instance;
import IceInternal.Time;
import IceUtilInternal.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class FactoryACMMonitor
implements ACMMonitor {
    private Instance _instance;
    private final ACMConfig _config;
    private Set<ConnectionI> _connections = new HashSet<ConnectionI>();
    private List<Change> _changes = new ArrayList<Change>();
    private List<ConnectionI> _reapedConnections = new ArrayList<ConnectionI>();
    private Future<?> _future;

    FactoryACMMonitor(Instance instance, ACMConfig config) {
        this._instance = instance;
        this._config = config;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._instance == null);
            Assert.FinalizerAssert(this._connections.isEmpty());
            Assert.FinalizerAssert(this._changes.isEmpty());
            Assert.FinalizerAssert(this._reapedConnections.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    synchronized void destroy() {
        if (this._instance == null) {
            while (!this._connections.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
        if (!this._connections.isEmpty()) {
            assert (this._future != null);
            this._future.cancel(false);
            this._future = null;
            this._instance.timer().schedule(new Runnable(){

                @Override
                public void run() {
                    FactoryACMMonitor.this.monitorConnections();
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
        this._instance = null;
        this._changes.clear();
        while (!this._connections.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ConnectionI connection) {
        if (this._config.timeout == 0) {
            return;
        }
        FactoryACMMonitor factoryACMMonitor = this;
        synchronized (factoryACMMonitor) {
            if (this._connections.isEmpty()) {
                this._connections.add(connection);
                assert (this._future == null);
                this._future = this._instance.timer().scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        FactoryACMMonitor.this.monitorConnections();
                    }
                }, this._config.timeout / 2, this._config.timeout / 2, TimeUnit.MILLISECONDS);
            } else {
                this._changes.add(new Change(connection, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ConnectionI connection) {
        if (this._config.timeout == 0) {
            return;
        }
        FactoryACMMonitor factoryACMMonitor = this;
        synchronized (factoryACMMonitor) {
            assert (this._instance != null);
            this._changes.add(new Change(connection, true));
        }
    }

    @Override
    public synchronized void reap(ConnectionI connection) {
        this._reapedConnections.add(connection);
    }

    @Override
    public synchronized ACMMonitor acm(IntOptional timeout, Optional<ACMClose> close, Optional<ACMHeartbeat> heartbeat) {
        assert (this._instance != null);
        ACMConfig config = this._config.clone();
        if (timeout != null && timeout.isSet()) {
            config.timeout = timeout.get() * 1000;
        }
        if (close != null && close.isSet()) {
            config.close = close.get();
        }
        if (heartbeat != null && heartbeat.isSet()) {
            config.heartbeat = heartbeat.get();
        }
        return new ConnectionACMMonitor(this, this._instance.timer(), config);
    }

    @Override
    public ACM getACM() {
        ACM acm = new ACM();
        acm.timeout = this._config.timeout / 1000;
        acm.close = this._config.close;
        acm.heartbeat = this._config.heartbeat;
        return acm;
    }

    synchronized List<ConnectionI> swapReapedConnections() {
        if (this._reapedConnections.isEmpty()) {
            return null;
        }
        List<ConnectionI> connections = this._reapedConnections;
        this._reapedConnections = new ArrayList<ConnectionI>();
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorConnections() {
        FactoryACMMonitor factoryACMMonitor = this;
        synchronized (factoryACMMonitor) {
            if (this._instance == null) {
                this._connections.clear();
                this.notifyAll();
                return;
            }
            for (Change change : this._changes) {
                if (change.remove) {
                    this._connections.remove(change.connection);
                    continue;
                }
                this._connections.add(change.connection);
            }
            this._changes.clear();
            if (this._connections.isEmpty()) {
                this._future.cancel(false);
                this._future = null;
                return;
            }
        }
        long now = Time.currentMonotonicTimeMillis();
        for (ConnectionI connection : this._connections) {
            try {
                connection.monitor(now, this._config);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    synchronized void handleException(Exception ex) {
        if (this._instance == null) {
            return;
        }
        this._instance.initializationData().logger.error("exception in connection monitor:\n" + ex);
    }

    static class Change {
        final ConnectionI connection;
        final boolean remove;

        Change(ConnectionI connection, boolean remove) {
            this.connection = connection;
            this.remove = remove;
        }
    }
}

