/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class GraphicsUtil {
    public static AffineTransform IDENTITY = new AffineTransform();
    public static final ColorModel Linear_sRGB = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel Linear_sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel Linear_sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    public static final ColorModel sRGB = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);

    public static ColorModel makeLinear_sRGBCM(boolean premult) {
        if (premult) {
            return Linear_sRGB_Pre;
        }
        return Linear_sRGB_Unpre;
    }

    public static BufferedImage makeLinearBufferedImage(int width, int height, boolean premult) {
        ColorModel cm = GraphicsUtil.makeLinear_sRGBCM(premult);
        WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
        return new BufferedImage(cm, wr, premult, null);
    }

    public static WritableRaster copyRaster(Raster ras) {
        return GraphicsUtil.copyRaster(ras, ras.getMinX(), ras.getMinY());
    }

    public static WritableRaster copyRaster(Raster ras, int minX, int minY) {
        WritableRaster ret = Raster.createWritableRaster(ras.getSampleModel(), new Point(0, 0));
        ret = ret.createWritableChild(ras.getMinX() - ras.getSampleModelTranslateX(), ras.getMinY() - ras.getSampleModelTranslateY(), ras.getWidth(), ras.getHeight(), minX, minY, null);
        DataBuffer srcDB = ras.getDataBuffer();
        DataBuffer retDB = ret.getDataBuffer();
        if (srcDB.getDataType() != retDB.getDataType()) {
            throw new IllegalArgumentException("New DataBuffer doesn't match original");
        }
        int len = srcDB.getSize();
        int banks = srcDB.getNumBanks();
        int[] offsets = srcDB.getOffsets();
        for (int b = 0; b < banks; ++b) {
            switch (srcDB.getDataType()) {
                case 0: {
                    DataBuffer srcDBT = (DataBufferByte)srcDB;
                    DataBuffer retDBT = (DataBufferByte)retDB;
                    System.arraycopy(((DataBufferByte)srcDBT).getData(b), offsets[b], ((DataBufferByte)retDBT).getData(b), offsets[b], len);
                }
                case 3: {
                    DataBuffer srcDBT = (DataBufferInt)srcDB;
                    DataBuffer retDBT = (DataBufferInt)retDB;
                    System.arraycopy(((DataBufferInt)srcDBT).getData(b), offsets[b], ((DataBufferInt)retDBT).getData(b), offsets[b], len);
                }
                case 2: {
                    DataBuffer srcDBT = (DataBufferShort)srcDB;
                    DataBuffer retDBT = (DataBufferShort)retDB;
                    System.arraycopy(((DataBufferShort)srcDBT).getData(b), offsets[b], ((DataBufferShort)retDBT).getData(b), offsets[b], len);
                }
                case 1: {
                    DataBuffer srcDBT = (DataBufferUShort)srcDB;
                    DataBuffer retDBT = (DataBufferUShort)retDB;
                    System.arraycopy(((DataBufferUShort)srcDBT).getData(b), offsets[b], ((DataBufferUShort)retDBT).getData(b), offsets[b], len);
                }
            }
        }
        return ret;
    }

    public static WritableRaster makeRasterWritable(Raster ras) {
        return GraphicsUtil.makeRasterWritable(ras, ras.getMinX(), ras.getMinY());
    }

    public static WritableRaster makeRasterWritable(Raster ras, int minX, int minY) {
        WritableRaster ret = Raster.createWritableRaster(ras.getSampleModel(), ras.getDataBuffer(), new Point(0, 0));
        ret = ret.createWritableChild(ras.getMinX() - ras.getSampleModelTranslateX(), ras.getMinY() - ras.getSampleModelTranslateY(), ras.getWidth(), ras.getHeight(), minX, minY, null);
        return ret;
    }

    public static ColorModel coerceColorModel(ColorModel cm, boolean newAlphaPreMult) {
        if (cm.isAlphaPremultiplied() == newAlphaPreMult) {
            return cm;
        }
        WritableRaster wr = cm.createCompatibleWritableRaster(1, 1);
        return cm.coerceData(wr, newAlphaPreMult);
    }

    public static ColorModel coerceData(WritableRaster wr, ColorModel cm, boolean newAlphaPreMult) {
        if (!cm.hasAlpha()) {
            return cm;
        }
        if (cm.isAlphaPremultiplied() == newAlphaPreMult) {
            return cm;
        }
        if (newAlphaPreMult) {
            GraphicsUtil.multiplyAlpha(wr);
        } else {
            GraphicsUtil.divideAlpha(wr);
        }
        return GraphicsUtil.coerceColorModel(cm, newAlphaPreMult);
    }

    public static void multiplyAlpha(WritableRaster wr) {
        if (GraphicsUtil.is_BYTE_COMP_Data(wr.getSampleModel())) {
            GraphicsUtil.mult_BYTE_COMP_Data(wr);
        } else if (GraphicsUtil.is_INT_PACK_Data(wr.getSampleModel(), true)) {
            GraphicsUtil.mult_INT_PACK_Data(wr);
        } else {
            int[] pixel = null;
            int bands = wr.getNumBands();
            float norm = 0.003921569f;
            int x0 = wr.getMinX();
            int x1 = x0 + wr.getWidth();
            int y0 = wr.getMinY();
            int y1 = y0 + wr.getHeight();
            for (int y = y0; y < y1; ++y) {
                for (int x = x0; x < x1; ++x) {
                    int a = (pixel = wr.getPixel(x, y, pixel))[bands - 1];
                    if (a < 0 || a >= 255) continue;
                    float alpha = (float)a * norm;
                    for (int b = 0; b < bands - 1; ++b) {
                        pixel[b] = (int)((float)pixel[b] * alpha + 0.5f);
                    }
                    wr.setPixel(x, y, pixel);
                }
            }
        }
    }

    public static void divideAlpha(WritableRaster wr) {
        if (GraphicsUtil.is_BYTE_COMP_Data(wr.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(wr);
        } else if (GraphicsUtil.is_INT_PACK_Data(wr.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(wr);
        } else {
            int bands = wr.getNumBands();
            int[] pixel = null;
            int x0 = wr.getMinX();
            int x1 = x0 + wr.getWidth();
            int y0 = wr.getMinY();
            int y1 = y0 + wr.getHeight();
            for (int y = y0; y < y1; ++y) {
                for (int x = x0; x < x1; ++x) {
                    int a = (pixel = wr.getPixel(x, y, pixel))[bands - 1];
                    if (a <= 0 || a >= 255) continue;
                    float ialpha = 255.0f / (float)a;
                    for (int b = 0; b < bands - 1; ++b) {
                        pixel[b] = (int)((float)pixel[b] * ialpha + 0.5f);
                    }
                    wr.setPixel(x, y, pixel);
                }
            }
        }
    }

    public static boolean is_INT_PACK_Data(SampleModel sm, boolean requireAlpha) {
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sm.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
        int[] masks = sppsm.getBitMasks();
        if (masks.length == 3 ? requireAlpha : masks.length != 4) {
            return false;
        }
        if (masks[0] != 0xFF0000) {
            return false;
        }
        if (masks[1] != 65280) {
            return false;
        }
        if (masks[2] != 255) {
            return false;
        }
        return masks.length != 4 || masks[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sm) {
        if (!(sm instanceof ComponentSampleModel)) {
            return false;
        }
        return sm.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster wr) {
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int width = wr.getWidth();
        int scanStride = sppsm.getScanlineStride();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int base = db.getOffset() + sppsm.getOffset(wr.getMinX() - wr.getSampleModelTranslateX(), wr.getMinY() - wr.getSampleModelTranslateY());
        int[] pixels = db.getBankData()[0];
        for (int y = 0; y < wr.getHeight(); ++y) {
            int sp;
            int end = sp + width;
            for (sp = base + y * scanStride; sp < end; ++sp) {
                int pixel = pixels[sp];
                int a = pixel >>> 24;
                if (a <= 0) {
                    pixels[sp] = 0xFFFFFF;
                    continue;
                }
                if (a >= 255) continue;
                int aFP = 0xFF0000 / a;
                pixels[sp] = a << 24 | ((pixel & 0xFF0000) >> 16) * aFP & 0xFF0000 | (((pixel & 0xFF00) >> 8) * aFP & 0xFF0000) >> 8 | ((pixel & 0xFF) * aFP & 0xFF0000) >> 16;
            }
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster wr) {
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int width = wr.getWidth();
        int scanStride = sppsm.getScanlineStride();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int base = db.getOffset() + sppsm.getOffset(wr.getMinX() - wr.getSampleModelTranslateX(), wr.getMinY() - wr.getSampleModelTranslateY());
        int[] pixels = db.getBankData()[0];
        for (int y = 0; y < wr.getHeight(); ++y) {
            int sp;
            int end = sp + width;
            for (sp = base + y * scanStride; sp < end; ++sp) {
                int pixel = pixels[sp];
                int a = pixel >>> 24;
                if (a < 0 || a >= 255) continue;
                pixels[sp] = a << 24 | (pixel & 0xFF0000) * a >> 8 & 0xFF0000 | (pixel & 0xFF00) * a >> 8 & 0xFF00 | (pixel & 0xFF) * a >> 8 & 0xFF;
            }
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster wr) {
        ComponentSampleModel csm = (ComponentSampleModel)wr.getSampleModel();
        int width = wr.getWidth();
        int scanStride = csm.getScanlineStride();
        int pixStride = csm.getPixelStride();
        int[] bandOff = csm.getBandOffsets();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        int base = db.getOffset() + csm.getOffset(wr.getMinX() - wr.getSampleModelTranslateX(), wr.getMinY() - wr.getSampleModelTranslateY());
        int a = 0;
        int aOff = bandOff[bandOff.length - 1];
        int bands = bandOff.length - 1;
        byte[] pixels = db.getBankData()[0];
        for (int y = 0; y < wr.getHeight(); ++y) {
            int sp;
            int end = sp + width * pixStride;
            for (sp = base + y * scanStride; sp < end; sp += pixStride) {
                int b;
                a = pixels[sp + aOff] & 0xFF;
                if (a == 0) {
                    for (b = 0; b < bands; ++b) {
                        pixels[sp + bandOff[b]] = -1;
                    }
                    continue;
                }
                if (a >= 255) continue;
                int aFP = 0xFF0000 / a;
                for (b = 0; b < bands; ++b) {
                    int i = sp + bandOff[b];
                    pixels[i] = (byte)((pixels[i] & 0xFF) * aFP >>> 16);
                }
            }
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster wr) {
        ComponentSampleModel csm = (ComponentSampleModel)wr.getSampleModel();
        int width = wr.getWidth();
        int scanStride = csm.getScanlineStride();
        int pixStride = csm.getPixelStride();
        int[] bandOff = csm.getBandOffsets();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        int base = db.getOffset() + csm.getOffset(wr.getMinX() - wr.getSampleModelTranslateX(), wr.getMinY() - wr.getSampleModelTranslateY());
        int a = 0;
        int aOff = bandOff[bandOff.length - 1];
        int bands = bandOff.length - 1;
        byte[] pixels = db.getBankData()[0];
        for (int y = 0; y < wr.getHeight(); ++y) {
            int sp;
            int end = sp + width * pixStride;
            for (sp = base + y * scanStride; sp < end; sp += pixStride) {
                a = pixels[sp + aOff] & 0xFF;
                if (a == 255) continue;
                for (int b = 0; b < bands; ++b) {
                    int i = sp + bandOff[b];
                    pixels[i] = (byte)((pixels[i] & 0xFF) * a >> 8);
                }
            }
        }
    }
}

