/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class ClearRecentFilesAction
extends AbstractApplicationAction {
    public static final String ID = "clearRecentFiles";
    private PropertyChangeListener applicationListener;

    public ClearRecentFilesAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, "clearMenu");
        this.updateEnabled();
    }

    protected void installApplicationListeners(Application app) {
        super.installApplicationListeners(app);
        if (this.applicationListener == null) {
            this.applicationListener = this.createApplicationListener();
        }
        app.addPropertyChangeListener(this.applicationListener);
    }

    private PropertyChangeListener createApplicationListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "recentFiles") {
                    ClearRecentFilesAction.this.updateEnabled();
                }
            }
        };
    }

    protected void uninstallApplicationListeners(Application app) {
        super.uninstallApplicationListeners(app);
        app.removePropertyChangeListener(this.applicationListener);
    }

    public void actionPerformed(ActionEvent e) {
        this.getApplication().clearRecentFiles();
    }

    private void updateEnabled() {
        this.setEnabled(this.getApplication().recentFiles().size() > 0);
    }
}

