/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.samples.svg.SVGProject;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.util.ResourceBundleUtil;

public class ViewSourceAction
extends AbstractProjectAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
    public static final String ID = "viewSource";

    public ViewSourceAction(Application app) {
        super(app);
        this.labels.configureAction(this, ID);
    }

    public void actionPerformed(ActionEvent e) {
        SVGProject p = (SVGProject)this.getCurrentProject();
        SVGOutputFormat format = new SVGOutputFormat();
        format.setPrettyPrint(true);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            format.write((OutputStream)buf, p.getDrawing());
            String source = buf.toString("UTF-8");
            JDialog dialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(p.getComponent()));
            dialog.setTitle(this.labels.getFormatted("viewSource.dialogTitle", p.getFile() == null ? "unnamed" : p.getFile().getName()));
            dialog.setResizable(true);
            dialog.setDefaultCloseOperation(2);
            JTextArea ta = new JTextArea(source);
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            JScrollPane sp = new JScrollPane(ta);
            dialog.getContentPane().add(sp);
            dialog.setSize(400, 400);
            dialog.setLocationByPlatform(true);
            dialog.setVisible(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

