/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PasswordResetAction
extends DataBrowserAction {
    private static final String NAME = "Reset Password...";
    private static final String DESCRIPTION = "Resets the password of the selected users.";

    @Override
    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (!DataBrowserAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (!DataBrowserAgent.isAdministrator()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getBrowser();
        if (browser == null || node == null || this.model.getType() != 8) {
            this.setEnabled(false);
            return;
        }
        Collection<ImageDisplay> nodes = browser.getSelectedDisplays();
        if (nodes.size() > 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(node.getHierarchyObject() instanceof ExperimenterData);
        }
    }

    public PasswordResetAction(DataBrowser model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(62));
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.resetPassword();
    }
}

