/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.DecoratorVisitor;

class ImagesModel
extends DataBrowserModel {
    private Collection<ImageData> images;

    ImagesModel(SecurityContext ctx, Object parent, Collection<ImageData> images) {
        super(ctx);
        if (images == null) {
            throw new IllegalArgumentException("No images.");
        }
        this.images = images;
        this.parent = parent;
        this.numberOfImages = images.size();
        Set visTrees = DataBrowserTranslator.transformImages(images);
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.browser.accept(new DecoratorVisitor(this.getCurrentUser().getId()));
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageNode node = i.next();
                ImageData img = (ImageData)node.getHierarchyObject();
                if (!ids.contains(img.getId()) || node.getThumbnail().getFullScaleThumb() != null) continue;
                try {
                    img.getDefaultPixels();
                    imgs.add(img);
                    ++this.imagesLoaded;
                }
                catch (Exception exception) {}
            }
        } else {
            while (i.hasNext()) {
                ImageNode node = i.next();
                ImageData img = (ImageData)node.getHierarchyObject();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                try {
                    img.getDefaultPixels();
                    imgs.add(img);
                    ++this.imagesLoaded;
                }
                catch (Exception e) {
                    --this.numberOfImages;
                }
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return this.createThumbnailsLoader(this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 1;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

