/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.TypeFilter_GUI;

public class TemplateDialog
extends JDialog
implements ActionListener {
    private JPanel chBoxPanel;
    private JButton btn_OK;
    private JButton btn_cancel;
    private JButton btn_filter_save;
    private JButton btn_filter_load;
    private JButton btn_browse_save;
    private JTextField txt_path;
    private JCheckBox cb_loadObjectData;
    private JCheckBox cb_loadTreeStructure;
    private JCheckBox cb_loadObjectDef;
    private List<String> moduleList;
    private File tempFile;
    private final String suffix = ".xml";
    private DefaultMutableTreeNode tree;
    private boolean cancel;
    private JButton btn_browse_load;

    public TemplateDialog(JFrame parent, File tempFile, boolean load, DefaultMutableTreeNode root) {
        super((Frame)parent, "");
        this.tempFile = tempFile;
        this.tree = root;
        this.cancel = false;
        if (load) {
            this.setTitle("Load Metadata from Template File ");
            this.buildGUI_loadFile();
        } else {
            this.setTitle("Save Metadata to Template File ");
            this.buildGUI_saveFile();
        }
        this.pack();
        this.setVisible(true);
    }

    private void buildGUI_loadFile() {
        this.setBounds(100, 100, 500, 600);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setModal(true);
        this.btn_OK = new JButton("OK");
        this.btn_OK.addActionListener(this);
        this.btn_cancel = new JButton("Cancel");
        this.btn_cancel.addActionListener(this);
        Box btnPane = Box.createHorizontalBox();
        btnPane.add(this.btn_cancel);
        btnPane.add(Box.createHorizontalStrut(5));
        btnPane.add(this.btn_OK);
        JPanel subPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Configuration:");
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        subPanel.setBorder(titleBorder);
        this.btn_filter_load = new JButton("Filter by objects: data to load...");
        this.btn_filter_load.setEnabled(false);
        this.btn_filter_load.addActionListener(this);
        subPanel.add(this.btn_filter_load);
        this.cb_loadObjectData = new JCheckBox("Load object data");
        this.cb_loadObjectData.setSelected(true);
        this.cb_loadObjectData.setEnabled(false);
        subPanel.add(this.cb_loadObjectData);
        this.cb_loadObjectDef = new JCheckBox("Load object definition");
        this.cb_loadObjectDef.setSelected(false);
        this.cb_loadObjectDef.setEnabled(false);
        subPanel.add(this.cb_loadObjectDef);
        this.cb_loadTreeStructure = new JCheckBox("Load tree structure");
        this.cb_loadTreeStructure.setSelected(false);
        this.cb_loadTreeStructure.setEnabled(false);
        subPanel.add(this.cb_loadTreeStructure);
        JLabel srcPath_Lbl = new JLabel("Source");
        this.txt_path = new JTextField(50);
        this.txt_path.setEditable(false);
        this.txt_path.setToolTipText("Source template file");
        if (this.tempFile != null) {
            this.txt_path.setText(this.tempFile.getAbsolutePath());
        }
        if (this.txt_path.getText() != null && !this.txt_path.getText().isEmpty()) {
            this.btn_filter_load.setEnabled(true);
        }
        this.btn_browse_load = new JButton("Browse");
        this.btn_browse_load.addActionListener(this);
        JPanel destP = new JPanel();
        destP.add(srcPath_Lbl);
        destP.add(this.txt_path);
        destP.add(this.btn_browse_load);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.add((Component)subPanel, "Center");
        mainPanel.add((Component)destP, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)btnPane, "South");
    }

    private void buildGUI_saveFile() {
        this.setBounds(100, 100, 500, 600);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setModal(true);
        this.btn_OK = new JButton("OK");
        this.btn_OK.addActionListener(this);
        this.btn_cancel = new JButton("Cancel");
        this.btn_cancel.addActionListener(this);
        Box btnPane = Box.createHorizontalBox();
        btnPane.add(this.btn_cancel);
        btnPane.add(Box.createHorizontalStrut(5));
        btnPane.add(this.btn_OK);
        this.btn_filter_save = new JButton("Filter by objects: data to save...");
        this.btn_filter_save.addActionListener(this);
        JPanel subPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Configuration:");
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        subPanel.setBorder(titleBorder);
        subPanel.add(this.btn_filter_save);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.add((Component)subPanel, "Center");
        JLabel destPath_Lbl = new JLabel("Destination");
        this.txt_path = new JTextField(50);
        this.txt_path.setEditable(false);
        this.txt_path.setToolTipText("Destination to store json template file");
        if (this.tempFile != null) {
            this.txt_path.setText(this.tempFile.getAbsolutePath());
        }
        this.btn_browse_save = new JButton("Browse");
        this.btn_browse_save.addActionListener(this);
        JPanel destP = new JPanel();
        destP.add(destPath_Lbl);
        destP.add(this.txt_path);
        destP.add(this.btn_browse_save);
        mainPanel.add((Component)destP, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)btnPane, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn_OK) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.btn_filter_load) {
            TypeFilter_GUI filterGUI = new TypeFilter_GUI(new JFrame(), this.tempFile.getAbsolutePath());
            this.moduleList = filterGUI.getTypeFilter();
        } else if (e.getSource() == this.btn_filter_save) {
            TypeFilter_GUI filterGui = new TypeFilter_GUI(new JFrame(), this.tree);
            this.moduleList = filterGui.getTypeFilter();
        } else if (e.getSource() == this.btn_cancel) {
            this.cancel = true;
            this.moduleList = null;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.btn_browse_save) {
            int returnValSave;
            FileNameExtensionFilter filter = new FileNameExtensionFilter("XML file", "xml");
            JFileChooser fcSave = new JFileChooser();
            fcSave.addChoosableFileFilter(filter);
            fcSave.setFileFilter(filter);
            if (this.tempFile != null) {
                fcSave.setCurrentDirectory(new File(this.tempFile.getParent()));
            }
            if ((returnValSave = fcSave.showSaveDialog(this)) == 0) {
                this.tempFile = fcSave.getSelectedFile();
                if (!fcSave.getSelectedFile().getAbsolutePath().endsWith(".xml")) {
                    this.tempFile = new File(fcSave.getSelectedFile() + ".xml");
                }
                this.txt_path.setText(this.tempFile.getAbsolutePath());
            }
        } else if (e.getSource() == this.btn_browse_load) {
            int returnValOpen;
            FileNameExtensionFilter filter = new FileNameExtensionFilter("XML file", "xml");
            JFileChooser fcOpen = new JFileChooser();
            fcOpen.addChoosableFileFilter(filter);
            fcOpen.setFileFilter(filter);
            if (this.tempFile != null) {
                fcOpen.setCurrentDirectory(new File(this.tempFile.getParent()));
            }
            if ((returnValOpen = fcOpen.showOpenDialog(this)) == 0) {
                this.tempFile = fcOpen.getSelectedFile();
                this.txt_path.setText(this.tempFile.getAbsolutePath());
                this.btn_filter_load.setEnabled(true);
            }
        }
    }

    public File getDestination() {
        return this.tempFile;
    }

    public List<String> getSelectionSave() {
        HashMap<String, ModuleContent> list;
        if (this.moduleList == null && (list = ModuleController.getInstance().getAvailableContent()) != null) {
            this.moduleList = new ArrayList<String>(list.keySet());
        }
        return this.moduleList;
    }

    public List<String> getSelectionLoad(List<String> availableTypelist) {
        if (this.moduleList == null) {
            HashMap<String, ModuleContent> list = ModuleController.getInstance().getAvailableContent();
            ArrayList<String> objectTypes = null;
            if (list != null) {
                objectTypes = new ArrayList<String>(list.keySet());
            }
            if (objectTypes != null && availableTypelist != null && !availableTypelist.isEmpty()) {
                this.moduleList = new ArrayList<String>();
                for (String s : objectTypes) {
                    if (!availableTypelist.contains(s)) continue;
                    this.moduleList.add(s);
                }
            }
        }
        return this.moduleList;
    }

    public Boolean loadTreeStructure() {
        return this.cb_loadTreeStructure.isSelected();
    }

    public Boolean isCancelled() {
        return this.cancel;
    }
}

