/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.OntologyElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser.OntologyParser;

public class OLS_Parser
extends OntologyParser {
    public OLS_Parser(String ontology_restapi_url) {
        this(ontology_restapi_url, "");
    }

    public OLS_Parser(String ontology_restapi_url, String acronym) {
        super(ontology_restapi_url, acronym);
    }

    @Override
    protected String formatURL(String ontology_acronym, String termID_href) {
        String id_utf8 = null;
        try {
            id_utf8 = "/" + URLEncoder.encode(URLEncoder.encode(termID_href, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Encoding error for ID_href");
            return null;
        }
        return this.REST_URL + "/api/ontologies/" + ontology_acronym + "/terms" + id_utf8 + "/children";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List<OntologyElement> getSubClassLabels(JsonNode ontology_node) throws Exception {
        if (ontology_node == null) {
            return null;
        }
        ArrayList<OntologyElement> labels = new ArrayList<OntologyElement>();
        try {
            JsonNode embedded_node = ontology_node.get("_embedded");
            if (embedded_node == null) return labels;
            for (JsonNode cls : embedded_node.get("terms")) {
                if (!cls.get("has_children").isNull() && cls.get("has_children").asBoolean()) {
                    String childId = cls.get("_links").get("children").get("href").asText();
                    labels.addAll(this.getSubClassLabels(this.getNode(childId)));
                    continue;
                }
                try {
                    if (cls == null) continue;
                    OntologyElement oElem = new OntologyElement(cls.get("label").asText(), cls.get("short_form").asText(), cls.get("ontology_iri").asText());
                    labels.add(oElem);
                }
                catch (Exception e) {
                    throw new UnsupportedEncodingException("Error while parsing from OLS: " + cls.get("label").asText());
                    return labels;
                }
            }
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(String.format("Exception while parsing from %s: %s", this.REST_URL, this.acronym));
        }
    }

    @Override
    protected List<String> getSubClassLabelsWithParents(JsonNode ontology_node, String parentLabel) throws Exception {
        if (ontology_node == null) {
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>();
        JsonNode embedded_node = ontology_node.get("_embedded");
        if (embedded_node != null) {
            for (JsonNode cls : embedded_node.get("terms")) {
                if (!cls.get("label").isNull()) {
                    labels.add(parentLabel + cls.get("label").asText());
                }
                if (cls.get("has_children").isNull() || !cls.get("has_children").asBoolean()) continue;
                String childId = cls.get("_links").get("children").get("href").asText();
                labels.addAll(this.getSubClassLabelsWithParents(this.getNode(childId), parentLabel + cls.get("label").asText() + ":"));
            }
        }
        return labels;
    }

    @Override
    protected HttpURLConnection initURLConnection(URL url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        return conn;
    }
}

