/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FailedImportDialog
extends JDialog {
    private SortedMap<String, String> errors = new TreeMap<String, String>();
    private final int MAX_ENTRIES = 50;

    public FailedImportDialog(JFrame owner, Collection<FileImportComponentI> components) {
        super(owner);
        for (FileImportComponentI c : components) {
            ImportErrorObject obj = c.getImportErrorObject();
            this.errors.put(UIUtilities.formatPartialName(obj.getFile().getAbsolutePath(), 60), UIUtilities.printErrorText(obj.getException()));
        }
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle("Failed imports");
        JPanel con = new JPanel();
        con.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        con.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 2;
        c.ipady = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        con.add((Component)new JLabel("File:"), c);
        String[] tmp = null;
        if (this.errors.keySet().size() < 50) {
            tmp = new String[this.errors.keySet().size()];
            tmp = this.errors.keySet().toArray(tmp);
        } else {
            tmp = new String[51];
            Iterator<String> it = this.errors.keySet().iterator();
            for (int i = 0; i < 50; ++i) {
                tmp[i] = it.next();
            }
            tmp[50] = "... and " + (this.errors.keySet().size() - 50) + " more.";
        }
        String selected = tmp[0];
        final JComboBox<String> filesBox = new JComboBox<String>(tmp);
        filesBox.setSelectedItem(selected);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        con.add(filesBox, c);
        selected = (String)this.errors.get(selected);
        final JTextArea errorText = new JTextArea(20, 60);
        errorText.setEditable(false);
        errorText.setText(selected);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        con.add((Component)new JLabel("Error log:"), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 1;
        JScrollPane sp = new JScrollPane(errorText);
        con.add((Component)sp, c);
        filesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sel = (String)filesBox.getSelectedItem();
                String text = (String)FailedImportDialog.this.errors.get(sel);
                errorText.setText(text != null ? text : "");
                errorText.setCaretPosition(0);
            }
        });
        JButton close = new JButton("Close");
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 26;
        c.fill = 0;
        con.add((Component)close, c);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FailedImportDialog.this.dispose();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)con, "Center");
        this.pack();
        errorText.setCaretPosition(0);
    }
}

