/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class RenderingSettingsLoader
extends DataLoader {
    private long pixelsID;
    private CallHandle handle;
    private boolean single;
    private long ownerID;

    public RenderingSettingsLoader(ImViewer viewer, SecurityContext ctx, long pixelsID) {
        this(viewer, ctx, pixelsID, false);
    }

    public RenderingSettingsLoader(ImViewer viewer, SecurityContext ctx, long pixelsID, boolean single) {
        super(viewer, ctx);
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.pixelsID = pixelsID;
        this.single = single;
        this.ownerID = -1L;
    }

    public void setOwner(long ownerID) {
        this.ownerID = ownerID;
    }

    @Override
    public void load() {
        if (this.single) {
            ExperimenterData exp = ImViewerAgent.getUserDetails();
            this.handle = this.ivView.getRenderingSettings(this.ctx, this.pixelsID, exp.getId(), this);
        } else {
            this.handle = this.ivView.getRenderingSettings(this.ctx, this.pixelsID, this);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 7) {
            return;
        }
        Map map = (Map)result;
        Iterator i = map.entrySet().iterator();
        if (this.single) {
            long userID = ImViewerAgent.getUserDetails().getId();
            while (i.hasNext()) {
                Collection def;
                Map.Entry entry = i.next();
                DataObject exp = (DataObject)entry.getKey();
                if (userID != exp.getId() || !CollectionUtils.isNotEmpty((Collection)(def = (Collection)entry.getValue()))) continue;
                this.viewer.setSettingsToPaste((RndProxyDef)def.iterator().next());
            }
        } else {
            HashMap<DataObject, RndProxyDef> m = new HashMap<DataObject, RndProxyDef>(map.size());
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                DataObject exp = (DataObject)entry.getKey();
                Collection def = (Collection)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)def)) continue;
                m.put((DataObject)entry.getKey(), (RndProxyDef)def.iterator().next());
            }
            this.viewer.setRenderingSettings(m, this.ownerID);
        }
    }
}

