/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class LensAction
extends ViewerAction {
    private static final String NAME = "Lens...";
    private static final String DESCRIPTION = "Show or hide the lens.";

    @Override
    protected void onStateChange(ChangeEvent e) {
        if (this.isEnabled()) {
            int sizeX = this.model.getMaxX();
            int sizeY = this.model.getMaxY();
            if (sizeX < 50 || sizeY < 50) {
                this.setEnabled(false);
            } else {
                this.setEnabled(!this.model.isBigImage());
            }
        }
    }

    public LensAction(ImViewer model) {
        super(model, NAME);
        this.setEnabled(true);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(4));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.showLens();
    }
}

