/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.ChannelData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.PixelsData;
import org.openmicroscopy.shoola.agents.events.FocusGainedEvent;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.iviewer.ChannelSelection;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageRendered;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurePlane;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerState;
import org.openmicroscopy.shoola.agents.events.metadata.ChannelSavedEvent;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.DeleteActivity;

public class MeasurementAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    private void handleMeasurementToolEvent(MeasurementTool evt) {
        PixelsData pixels = evt.getPixels();
        if (pixels == null) {
            return;
        }
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, pixels.getId());
        if (viewer == null) {
            viewer = MeasurementViewerFactory.getViewer(evt.getSecurityContext(), evt.getPixels(), evt.getImageID(), evt.getName(), evt.getRequesterBounds(), evt.getDefaultZ(), evt.getDefaultT(), evt.getMagnification(), evt.getActiveChannels(), evt.getChannelData());
        }
        if (viewer != null) {
            viewer.setIconImage(evt.getThumbnail());
            viewer.setRndImage(evt.getRenderedImage());
            MeasurementViewerFactory.addRequest(evt);
            viewer.activate(evt.getMeasurements(), evt.isHCSData(), evt.isBigImage());
        }
    }

    private void handleMeasurePlaneEvent(MeasurePlane evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, evt.getPixelsID());
        if (viewer != null) {
            viewer.setMagnifiedPlane(evt.getDefaultZ(), evt.getDefaultT(), evt.getMagnification());
        }
    }

    private void handleViewerStateEvent(ViewerState evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, evt.getPixelsID());
        if (viewer != null) {
            switch (evt.getIndex()) {
                case 0: {
                    viewer.discard();
                    break;
                }
                case 1: {
                    viewer.iconified(false);
                    break;
                }
                case 2: {
                    viewer.iconified(true);
                }
            }
        }
    }

    private void handleFocusGainedEvent(FocusGainedEvent evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        if (viewer.getState() != 6 || evt.getIndex() != 1) {
            // empty if block
        }
    }

    private void handleChannelSelectionEvent(ChannelSelection evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, evt.getPixelsID());
        if (viewer != null) {
            switch (evt.getIndex()) {
                case 1: {
                    viewer.setActiveChannels(evt.getChannels());
                    break;
                }
                case 0: {
                    viewer.setActiveChannelsColor(evt.getChannels());
                }
            }
        }
    }

    private void handleSaveData(SaveData evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, evt.getPixelsID());
        if (viewer != null && evt.getType() == 0) {
            viewer.saveROIToServer(true);
            viewer.discard();
        }
    }

    private void handleImageRenderedEvent(ImageRendered evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(null, evt.getPixelsID());
        if (viewer != null) {
            viewer.setIconImage(evt.getThumbnail());
            viewer.setRndImage(evt.getRenderedImage());
        }
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        MeasurementViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleReconnectedEvent(ReconnectedEvent evt) {
        MeasurementViewerFactory.onGroupSwitched(true);
    }

    private void handleChannelSavedEvent(ChannelSavedEvent evt) {
        List<ChannelData> channels = evt.getChannels();
        Iterator<Long> i = evt.getImageIds().iterator();
        SecurityContext ctx = evt.getSecurityContext();
        while (i.hasNext()) {
            MeasurementViewer viewer = MeasurementViewerFactory.getViewerFromImage(ctx, i.next());
            if (viewer == null) continue;
            viewer.onUpdatedChannels(channels);
        }
    }

    private void handleActivityFinished(ActivityProcessEvent evt) {
        if (evt == null) {
            return;
        }
        ActivityComponent comp = evt.getActivity();
        if (comp instanceof DeleteActivity) {
            MeasurementViewerFactory.onROIDeleted(((DeleteActivity)comp).getImageID());
        }
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static Collection getAvailableUserGroups() {
        return (Collection)registry.lookup("/userGroup/details");
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean canCreate() {
        Boolean b = (Boolean)registry.lookup("canCreate");
        return b;
    }

    @Override
    public void activate(boolean master) {
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = ctx.getEventBus();
        bus.register((AgentEventListener)this, MeasurementTool.class);
        bus.register((AgentEventListener)this, MeasurePlane.class);
        bus.register((AgentEventListener)this, ViewerState.class);
        bus.register((AgentEventListener)this, ChannelSelection.class);
        bus.register((AgentEventListener)this, SaveData.class);
        bus.register((AgentEventListener)this, FocusGainedEvent.class);
        bus.register((AgentEventListener)this, ImageRendered.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ActivityProcessEvent.class);
        bus.register((AgentEventListener)this, ReconnectedEvent.class);
        bus.register((AgentEventListener)this, ChannelSavedEvent.class);
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        List<Object> instances = MeasurementViewerFactory.getInstancesToSave();
        if (instances == null || instances.size() == 0) {
            return null;
        }
        return new AgentSaveInfo("Measurements", instances);
    }

    @Override
    public void save(List<Object> instances) {
        MeasurementViewerFactory.saveInstances(instances);
    }

    @Override
    public void terminate() {
        Environment env = (Environment)registry.lookup("/env");
        if (env.isRunAsPlugin()) {
            MeasurementViewerFactory.onGroupSwitched(true);
        }
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof MeasurementTool) {
            this.handleMeasurementToolEvent((MeasurementTool)e);
        } else if (e instanceof MeasurePlane) {
            this.handleMeasurePlaneEvent((MeasurePlane)e);
        } else if (e instanceof ViewerState) {
            this.handleViewerStateEvent((ViewerState)e);
        } else if (e instanceof ChannelSelection) {
            this.handleChannelSelectionEvent((ChannelSelection)e);
        } else if (e instanceof SaveData) {
            this.handleSaveData((SaveData)e);
        } else if (e instanceof FocusGainedEvent) {
            this.handleFocusGainedEvent((FocusGainedEvent)e);
        } else if (e instanceof ImageRendered) {
            this.handleImageRenderedEvent((ImageRendered)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ActivityProcessEvent && ((ActivityProcessEvent)e).isFinished()) {
            this.handleActivityFinished((ActivityProcessEvent)e);
        } else if (e instanceof ReconnectedEvent) {
            this.handleReconnectedEvent((ReconnectedEvent)e);
        } else if (e instanceof ChannelSavedEvent) {
            this.handleChannelSavedEvent((ChannelSavedEvent)e);
        }
    }
}

