/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.awt.Component;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import omero.gateway.model.FolderData;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class ROITableCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static Icon SHAPE_ICON;
    private static Icon ROI_ICON;
    private static Icon ROI_OTHER_OWNER_ICON;
    private static Icon FOLDER_ICON;
    private static Icon FOLDER_OTHER_OWNER_ICON;
    private long userID;

    public ROITableCellRenderer() {
        this.setOpaque(false);
        this.userID = MeasurementAgent.getUserDetails().getId();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ROINode node = (ROINode)((Object)value);
        if (node.isROINode()) {
            ROI roi = (ROI)node.getUserObject();
            if (this.userID == roi.getOwnerID() || roi.getOwnerID() == -1L) {
                this.setIcon(ROI_ICON);
            } else {
                this.setIcon(ROI_OTHER_OWNER_ICON);
            }
            TreeMap<Coord3D, ROIShape> map = roi.getShapes();
            if (map == null) {
                this.setText("[0]");
            } else {
                this.setText("[" + map.size() + "]");
            }
        } else if (node.isShapeNode()) {
            this.setIcon(SHAPE_ICON);
            this.setText("");
        } else if (node.isFolderNode()) {
            FolderData folder = (FolderData)node.getUserObject();
            if (this.userID == folder.getOwner().getId()) {
                this.setIcon(FOLDER_ICON);
            } else {
                this.setIcon(FOLDER_OTHER_OWNER_ICON);
            }
            this.setText(folder.getName() + " [" + node.getChildCount() + "]");
        }
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        SHAPE_ICON = icons.getIcon(29);
        ROI_ICON = icons.getIcon(28);
        ROI_OTHER_OWNER_ICON = icons.getIcon(46);
        FOLDER_ICON = icons.getIcon(47);
        FOLDER_OTHER_OWNER_ICON = icons.getIcon(50);
    }
}

