/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import omero.gateway.model.AnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public abstract class AnnotationTaskPaneUI
extends JPanel {
    EditorModel model;
    EditorUI view;
    EditorControl controller;
    Filter filter = Filter.SHOW_ALL;
    private JPanel contentPane;

    AnnotationTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        this.model = model;
        this.view = view;
        this.controller = controller;
        this.contentPane = new JPanel();
        this.contentPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        super.setLayout(new BorderLayout());
        super.add((Component)this.getToolbar(), "North");
        super.add((Component)this.contentPane, "Center");
    }

    void filter(Filter filter) {
        this.filter = filter;
        this.refreshUI();
    }

    private JPanel getToolbar() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new FlowLayout(2));
        List<JButton> buttons = this.getToolbarButtons();
        if (CollectionUtils.isNotEmpty(buttons)) {
            for (JButton b : buttons) {
                p.add(b);
            }
        }
        return p;
    }

    JPanel getContentPane() {
        return this.contentPane;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.contentPane == null) {
            super.setLayout(mgr);
        } else {
            this.contentPane.setLayout(mgr);
        }
    }

    @Override
    public Component add(Component comp) {
        return this.contentPane.add(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.contentPane.add(name, comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.contentPane.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.contentPane.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.contentPane.add(comp, constraints, index);
    }

    @Override
    public void remove(int index) {
        this.contentPane.remove(index);
    }

    @Override
    public void removeAll() {
        this.contentPane.removeAll();
    }

    List<JButton> getToolbarButtons() {
        return Collections.emptyList();
    }

    abstract void refreshUI();

    abstract void clearDisplay();

    abstract List<AnnotationData> getAnnotationsToSave();

    abstract List<Object> getAnnotationsToRemove();

    abstract void onRelatedNodesSet();

    abstract int getUnfilteredAnnotationCount();

    public static enum Filter {
        SHOW_ALL("Show all"),
        ADDED_BY_ME("Show added by me"),
        ADDED_BY_OTHERS("Show added by others");

        String name = "";

        private Filter(String name) {
            this.name = name;
        }
    }
}

