/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CopyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CutCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManageObjectAction
extends TreeViewerAction {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int REMOVE = 2;
    public static final int CUT = 3;
    private static final String NAME_COPY_LINK = "Copy Link";
    private static final String DESCRIPTION_COPY_LINK = "Copy link(s) to the selected element(s) into the clipboard.";
    private static final String NAME_COPY = "Copy";
    private static final String DESCRIPTION_COPY = "Copy the selected element(s) into the clipboard.";
    private static final String NAME_PASTE_LINK = "Paste Link";
    private static final String DESCRIPTION_PASTE_LINK = "Paste link(s) from the clipboard.";
    private static final String NAME_PASTE = "Paste";
    private static final String DESCRIPTION_PASTE = "Paste element(s) from the clipboard.";
    private static final String NAME_REMOVE = "Delete";
    private static final String DESCRIPTION_REMOVE = "Delete the selected elements.";
    private static final String NAME_CUT_LINK = "Cut Link";
    private static final String DESCRIPTION_CUT_LINK = "Cut the selected link(s).";
    private static final String NAME_CUT = "Cut";
    private static final String DESCRIPTION_CUT = "Cut the selected element(s).";
    private static final String[] KEYS = new String[]{"system", "guest"};
    private int index;
    private IconManager icons = IconManager.getInstance();
    private long userID;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.name = NAME_COPY_LINK;
                this.putValue("Name", NAME_COPY_LINK);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY_LINK));
                this.putValue("SmallIcon", this.icons.getIcon(24));
                break;
            }
            case 1: {
                this.name = NAME_PASTE_LINK;
                this.putValue("Name", NAME_PASTE_LINK);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE_LINK));
                this.putValue("SmallIcon", this.icons.getIcon(25));
                break;
            }
            case 2: {
                this.name = NAME_REMOVE;
                this.putValue("Name", NAME_REMOVE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_REMOVE));
                this.putValue("SmallIcon", this.icons.getIcon(26));
                break;
            }
            case 3: {
                this.name = NAME_CUT_LINK;
                this.putValue("Name", NAME_CUT_LINK);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT_LINK));
                this.putValue("SmallIcon", this.icons.getIcon(50));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    private boolean isPasteValid(Object ho, List<DataObject> list) {
        Iterator<DataObject> i = list.iterator();
        int count = 0;
        while (i.hasNext()) {
            DataObject os = i.next();
            if (!EditorUtil.isTransferable(ho, os, this.userID)) {
                return false;
            }
            ++count;
        }
        return count == list.size();
    }

    private void adaptActionNameDescription(int browserType) {
        if (browserType == 6) {
            switch (this.index) {
                case 3: {
                    this.name = NAME_CUT;
                    this.putValue("Name", NAME_CUT);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT));
                    break;
                }
                case 0: {
                    this.name = NAME_COPY;
                    this.putValue("Name", NAME_COPY);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                    break;
                }
                case 1: {
                    this.name = NAME_PASTE;
                    this.putValue("Name", NAME_PASTE);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                }
            }
        } else {
            switch (this.index) {
                case 3: {
                    this.name = NAME_CUT_LINK;
                    this.putValue("Name", NAME_CUT_LINK);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT_LINK));
                    break;
                }
                case 0: {
                    this.name = NAME_COPY_LINK;
                    this.putValue("Name", NAME_COPY_LINK);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY_LINK));
                    break;
                }
                case 1: {
                    this.name = NAME_PASTE_LINK;
                    this.putValue("Name", NAME_PASTE_LINK);
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE_LINK));
                }
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        this.adaptActionNameDescription(browser.getBrowserType());
        Object ho = selectedDisplay.getUserObject();
        int count = 0;
        TreeImageDisplay parentDisplay = selectedDisplay.getParentDisplay();
        Object parent = null;
        if (parentDisplay != null) {
            parent = parentDisplay.getUserObject();
        }
        switch (this.index) {
            case 1: {
                List<DataObject> list = this.model.getDataToCopy();
                if (list == null || list.size() == 0) {
                    this.setEnabled(false);
                    return;
                }
                if (ho instanceof ProjectData || ho instanceof ScreenData || ho instanceof DatasetData || ho instanceof GroupData || ho instanceof TagAnnotationData) {
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        ho = selected[i].getUserObject();
                        if (!this.isPasteValid(ho, list)) continue;
                        if (ho instanceof GroupData) {
                            ++count;
                            continue;
                        }
                        if (!this.model.canLink(ho)) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData || ho instanceof GroupData) {
                    if (browser.getBrowserType() == 6) break;
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        ho = selected[i].getUserObject();
                        if (!this.isPasteValid(ho, list)) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 2: {
                if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof ScreenData || ho instanceof PlateData || ho instanceof PlateAcquisitionData || ho instanceof FileAnnotationData || ho instanceof TagAnnotationData || ho instanceof ImageData) {
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.canDelete(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    if (browser.getBrowserType() == 6) {
                        this.setEnabled(false);
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof GroupData) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 0: 
            case 3: {
                if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof PlateData) {
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.canLink(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    if (this.index == 3) {
                        if (ho instanceof DatasetData) {
                            if (!(parent instanceof ProjectData)) {
                                this.setEnabled(false);
                                return;
                            }
                        } else if (ho instanceof ImageData) {
                            if (!(parent instanceof DatasetData) && !(parent instanceof TagAnnotationData)) {
                                this.setEnabled(false);
                                return;
                            }
                        } else if (ho instanceof PlateData && !(parent instanceof ScreenData)) {
                            this.setEnabled(false);
                            return;
                        }
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    if (this.index == 0) {
                        this.setEnabled(browser.getBrowserType() == 6);
                        break;
                    }
                    this.setEnabled(false);
                    if (browser.getBrowserType() != 6 || !(parent instanceof GroupData)) break;
                    GroupData g = (GroupData)parent;
                    Boolean b = null;
                    for (int i = 0; i < KEYS.length; ++i) {
                        if (!this.model.isSystemGroup(g.getId(), KEYS[i])) continue;
                        ExperimenterData user = this.model.getUserDetails();
                        ExperimenterData exp = (ExperimenterData)ho;
                        b = exp.getId() != user.getId() && !this.model.isSystemUser(exp.getId(), KEYS[i]);
                        break;
                    }
                    if (b != null) {
                        this.setEnabled(b);
                        break;
                    }
                    this.setEnabled(true);
                    break;
                }
                if (ho instanceof TagAnnotationData) {
                    TagAnnotationData tag = (TagAnnotationData)ho;
                    if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                        this.setEnabled(false);
                        break;
                    }
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.canAnnotate(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    if (this.index == 3 && !(parent instanceof TagAnnotationData)) {
                        this.setEnabled(false);
                        return;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    public ManageObjectAction(TreeViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
        this.userID = model.getUserDetails().getId();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionCmd cmd = null;
        switch (this.index) {
            case 0: {
                cmd = new CopyCmd(this.model);
                break;
            }
            case 1: {
                cmd = new PasteCmd(this.model);
                break;
            }
            case 2: {
                cmd = new DeleteCmd(this.model.getSelectedBrowser());
                break;
            }
            case 3: {
                cmd = new CutCmd(this.model);
            }
        }
        if (cmd != null) {
            cmd.execute();
        }
    }
}

