/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;

public class ContainerFinder
implements TreeImageDisplayVisitor {
    private Set<TreeImageSet> containerNodes;
    private Set<DataObject> containers;
    private List<Class> rootType;

    public ContainerFinder(Class rootType) {
        this.rootType = Arrays.asList(rootType);
        this.containerNodes = new HashSet<TreeImageSet>();
        this.containers = new HashSet<DataObject>();
    }

    public ContainerFinder(List<Class> rootType) {
        this.rootType = rootType;
        this.containerNodes = new HashSet<TreeImageSet>();
        this.containers = new HashSet<DataObject>();
    }

    public Set<TreeImageSet> getContainerNodes() {
        return this.containerNodes;
    }

    public Set<DataObject> getContainers() {
        return this.containers;
    }

    @Override
    public void visit(TreeImageNode node) {
    }

    @Override
    public void visit(TreeImageSet node) {
        Object userObject = node.getUserObject();
        if (userObject != null && this.rootType.contains(userObject.getClass())) {
            TagAnnotationData tag;
            String ns;
            if (userObject instanceof DatasetData || userObject instanceof GroupData || userObject instanceof ExperimenterData) {
                this.containerNodes.add(node);
                this.containers.add((DataObject)userObject);
            } else if (userObject instanceof TagAnnotationData && !"openmicroscopy.org/omero/insight/tagset".equals(ns = (tag = (TagAnnotationData)userObject).getNameSpace())) {
                this.containerNodes.add(node);
                this.containers.add((DataObject)userObject);
            }
        }
    }
}

