/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.ui.SelectionTable;
import org.openmicroscopy.shoola.agents.util.ui.UserManagerDialog;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class GroupManagerDialog
extends JDialog
implements ActionListener {
    public static final String GROUP_SWITCH_PROPERTY = "groupSwitch";
    public static final String TITLE = "Groups Selection";
    private static final int CANCEL = 0;
    private static final int APPLY = 1;
    private static final String TEXT = "Select at least one group.";
    private static final String CANCEL_DESCRIPTION = "Close the window.";
    private static final String APPLY_DESCRIPTION = "Select the experimenters.";
    private SelectionTable groupsTable;
    private JButton cancel;
    private JButton apply;
    private Collection groups;

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.apply);
        bar.add(Box.createRigidArea(UserManagerDialog.H_SPACER_SIZE));
        bar.add(this.cancel);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private void buildGUI(Icon icon) {
        TitlePanel titlePanel = new TitlePanel(TITLE, TEXT, icon);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)titlePanel), "North");
        c.add((Component)new JScrollPane(this.groupsTable), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void initComponents(List<GroupData> selectedGroups) {
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText(UIUtilities.formatToolTipText(CANCEL_DESCRIPTION));
        this.cancel.addActionListener(this);
        this.cancel.setActionCommand("0");
        this.apply = new JButton("Apply");
        this.apply.addActionListener(this);
        this.apply.setActionCommand("1");
        this.apply.setToolTipText(UIUtilities.formatToolTipText(APPLY_DESCRIPTION));
        this.getRootPane().setDefaultButton(this.apply);
        ViewerSorter sorter = new ViewerSorter();
        List l = sorter.sort(this.groups);
        this.groupsTable = new SelectionTable();
        this.groupsTable.setGroups(l);
        ArrayList<Long> ids = new ArrayList<Long>(selectedGroups.size());
        Iterator<GroupData> i = selectedGroups.iterator();
        while (i.hasNext()) {
            ids.add(i.next().getId());
        }
        DefaultTableModel model = (DefaultTableModel)this.groupsTable.getModel();
        i = l.iterator();
        int index = 0;
        while (i.hasNext()) {
            GroupData g = i.next();
            model.insertRow(index, new Object[]{g, new Boolean(ids.contains(g.getId()))});
            ++index;
        }
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                int rows = GroupManagerDialog.this.groupsTable.getModel().getRowCount();
                int count = 0;
                for (int j = 0; j < rows; ++j) {
                    if (!((Boolean)GroupManagerDialog.this.groupsTable.getValueAt(j, 1)).booleanValue()) continue;
                    ++count;
                }
                GroupManagerDialog.this.apply.setEnabled(count != 0);
            }
        };
        this.groupsTable.getSelectionModel().addListSelectionListener(listener);
        this.groupsTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    private void apply() {
        ArrayList<GroupData> groups = new ArrayList<GroupData>();
        for (int i = 0; i < this.groupsTable.getRowCount(); ++i) {
            Boolean b = (Boolean)this.groupsTable.getValueAt(i, 1);
            if (!b.booleanValue()) continue;
            groups.add((GroupData)this.groupsTable.getValueAt(i, 0));
        }
        this.firePropertyChange(GROUP_SWITCH_PROPERTY, null, groups);
        this.cancel();
    }

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
    }

    public GroupManagerDialog(JFrame parent, Collection groups, List<GroupData> selectedGroups, Icon icon) {
        super(parent);
        this.setProperties();
        this.groups = groups;
        this.initComponents(selectedGroups);
        this.buildGUI(icon);
    }

    public void setDefaultSize() {
        this.setSize(UserManagerDialog.DEFAULT_SIZE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int id = Integer.parseInt(e.getActionCommand());
        switch (id) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.apply();
            }
        }
    }
}

