/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.util.ui.UserManagerDialog;

class UserListRenderer
extends JLabel
implements ListCellRenderer {
    private static final Border BORDER = new EmptyBorder(5, 5, 5, 5);
    private static final Color BACKGROUND = Color.WHITE;
    private static final Color BACKGROUND_ONE = new Color(236, 243, 254);
    private static final int GAP = 20;
    private Icon userIcon;
    private Font font;
    private Font defaultFont;
    private UserManagerDialog model;

    private boolean isAlreadySelected(ExperimenterData experimenter) {
        long id = experimenter.getId();
        for (ExperimenterData exp : this.model.getSelectedUsers()) {
            if (exp.getId() != id) continue;
            return true;
        }
        return false;
    }

    public UserListRenderer(UserManagerDialog model, Icon userIcon) {
        this.setOpaque(true);
        this.model = model;
        this.userIcon = userIcon;
        this.defaultFont = this.getFont();
        this.font = this.defaultFont.deriveFont(3, this.defaultFont.getSize() - 2);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        this.setEnabled(true);
        if (value instanceof String) {
            this.setFont(this.font);
            this.setIcon(null);
            this.setText((String)value);
            this.setForeground(list.getForeground());
            this.setBackground(BACKGROUND);
        } else if (value instanceof ExperimenterData) {
            this.setVerticalAlignment(0);
            this.setFont(this.defaultFont);
            this.setIcon(this.userIcon);
            this.setIconTextGap(20);
            ExperimenterData data = (ExperimenterData)value;
            this.setText(data.getFirstName() + " " + data.getLastName());
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                if (index % 2 == 0) {
                    this.setBackground(BACKGROUND);
                } else {
                    this.setBackground(BACKGROUND_ONE);
                }
            }
            this.setEnabled(!this.isAlreadySelected((ExperimenterData)value));
        }
        this.setBorder(BORDER);
        return this;
    }
}

