/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.in.OMEXMLReader;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.model.MapAnnotation;
import omero.model.MapAnnotationI;
import omero.model.NamedValue;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImportableObject {
    public static final String DEFAULT_DATASET_NAME;
    public static final Set<String> HCS_FILES_EXTENSION;
    private static final List<String> ARBITRARY_FILES_EXTENSION;
    public static final List<String> HCS_DOMAIN;
    public static final List<String> OME_SUFFIXES;
    public static final TIFFFilter FILTER;
    public static final String DAT_EXTENSION = "dat";
    public static String OPTION_THUMBNAILS;
    public static String OPTION_SKIP_MINMAX;
    public static String OPTION_CHECKSUMS;
    private List<ImportableFile> files;
    private int depthForName;
    private int scanningDepth;
    private boolean overrideName;
    private Collection<TagAnnotationData> tags;
    private Map<String, List<MapAnnotationData>> mapAnnots;
    private double[] pixelsSize;
    private Class type;
    private boolean loadThumbnail;
    private List<Object> refNodes;
    private List<DataObject> newObjects;
    private Map<Long, List<DatasetData>> projectDatasetMap;
    private Map<String, Object> skipChoices;

    private static void populateExtensions(String[] suffixes) {
        if (suffixes != null) {
            for (int i = 0; i < suffixes.length; ++i) {
                String s = suffixes[i];
                if (s == null || s.trim().length() <= 0) continue;
                HCS_FILES_EXTENSION.add(s.toLowerCase());
            }
        }
    }

    public static boolean isArbitraryFile(File f) {
        if (f == null) {
            return false;
        }
        String name = f.getName();
        if (!name.contains(".")) {
            return false;
        }
        String ext = FilenameUtils.getExtension((String)name);
        return ARBITRARY_FILES_EXTENSION.contains(ext);
    }

    private ImportableFile getImportableFile(File f) {
        Iterator<ImportableFile> i = this.files.iterator();
        String path = f.getAbsolutePath();
        while (i.hasNext()) {
            ImportableFile iFile = i.next();
            if (!path.equals(iFile.getFile().getAbsolutePath())) continue;
            return iFile;
        }
        return null;
    }

    private String getObjectName(DataObject object) {
        if (object instanceof DatasetData) {
            return ((DatasetData)object).getName();
        }
        if (object instanceof ProjectData) {
            return ((ProjectData)object).getName();
        }
        if (object instanceof ScreenData) {
            return ((ScreenData)object).getName();
        }
        return "";
    }

    public ImportableObject(List<ImportableFile> files, boolean overrideName) {
        this.files = files;
        this.overrideName = overrideName;
        this.type = DatasetData.class;
        this.depthForName = -1;
        this.loadThumbnail = true;
        this.newObjects = new ArrayList<DataObject>();
        this.projectDatasetMap = new HashMap<Long, List<DatasetData>>();
        this.skipChoices = new HashMap<String, Object>();
        this.mapAnnots = new HashMap<String, List<MapAnnotationData>>();
    }

    public void setSkipChoices(Map<String, Object> choices) {
        if (this.skipChoices == null) {
            this.skipChoices = new HashMap<String, Object>(choices);
        } else {
            this.skipChoices.putAll(choices);
        }
    }

    public void setLoadThumbnail(boolean loadThumbnail) {
        this.loadThumbnail = loadThumbnail;
    }

    public boolean isLoadThumbnail() {
        return this.loadThumbnail;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setPixelsSize(double[] pixelsSize) {
        this.pixelsSize = pixelsSize;
    }

    public void setTags(Collection<TagAnnotationData> tags) {
        this.tags = tags;
    }

    public void setMapAnnotation(Map<String, List<MapAnnotationData>> map) {
        this.mapAnnots = this.getCloneOfMap(map);
    }

    public void setScanningDepth(int scanningDepth) {
        this.scanningDepth = scanningDepth;
    }

    public int getScanningDepth() {
        return this.scanningDepth;
    }

    public void setDepthForName(int depthForName) {
        this.depthForName = depthForName;
    }

    public int getDepthForName() {
        return this.depthForName;
    }

    public List<ImportableFile> getFiles() {
        return this.files;
    }

    public DataObject createFolderAsContainer(ImportableFile file) {
        return this.createFolderAsContainer(file, false);
    }

    public DataObject createFolderAsContainer(ImportableFile file, boolean hcs) {
        if (file == null) {
            return null;
        }
        Class<ScreenData> klass = this.type;
        if (hcs) {
            klass = ScreenData.class;
        }
        FileObject f = file.getFile();
        boolean b = file.isFolderAsContainer();
        if (!b) {
            return null;
        }
        String name = f.getFolderAsContainerName();
        if (CommonsLangUtils.isBlank(name)) {
            return null;
        }
        if (DatasetData.class.equals(klass)) {
            DatasetData dataset = new DatasetData();
            dataset.setName(name);
            return dataset;
        }
        if (ScreenData.class.equals(klass)) {
            ScreenData screen = new ScreenData();
            screen.setName(name);
            return screen;
        }
        return null;
    }

    public Class getRootType() {
        if (ScreenData.class.equals((Object)this.type)) {
            return this.type;
        }
        return ProjectData.class;
    }

    public boolean isOverrideName() {
        return this.overrideName;
    }

    public Double[] getPixelsSize() {
        if (this.pixelsSize != null && this.pixelsSize.length > 0) {
            Double[] array = new Double[this.pixelsSize.length];
            for (int i = 0; i < this.pixelsSize.length; ++i) {
                array[i] = new Double(this.pixelsSize[i]);
            }
            return array;
        }
        return null;
    }

    public Collection<TagAnnotationData> getTags() {
        return this.tags;
    }

    public Map<String, List<MapAnnotationData>> getMap() {
        return this.mapAnnots;
    }

    public Map<String, List<MapAnnotationData>> getCloneOfMap(Map<String, List<MapAnnotationData>> map) {
        HashMap<String, List<MapAnnotationData>> mdeMap = new HashMap<String, List<MapAnnotationData>>();
        if (map != null) {
            for (Map.Entry<String, List<MapAnnotationData>> entry : map.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                ArrayList<MapAnnotationData> mapValue = new ArrayList<MapAnnotationData>();
                for (MapAnnotationData mapdata : entry.getValue()) {
                    List valuesOrig = (List)mapdata.getContent();
                    MapAnnotationI ma = new MapAnnotationI();
                    ArrayList<NamedValue> values = new ArrayList<NamedValue>();
                    if (valuesOrig != null) {
                        for (NamedValue val : valuesOrig) {
                            values.add(new NamedValue(val.name, val.value));
                        }
                    }
                    ma.setMapValue(values);
                    MapAnnotationData newdata = new MapAnnotationData((MapAnnotation)ma);
                    newdata.setNameSpace(mapdata.getNameSpace());
                    newdata.setDescription(mapdata.getDescription());
                    mapValue.add(newdata);
                }
                mdeMap.put(entry.getKey(), mapValue);
            }
        }
        return mdeMap;
    }

    public boolean hasNewTags() {
        if (this.tags == null || this.tags.size() == 0) {
            return false;
        }
        for (TagAnnotationData tag : this.tags) {
            if (tag.getId() > 0L) continue;
            return true;
        }
        return false;
    }

    public List<Object> getRefNodes() {
        return this.refNodes;
    }

    public void setRefNodes(List<Object> refNodes) {
        this.refNodes = refNodes;
    }

    public static boolean isHCSFile(FileObject f) {
        if (f == null) {
            return false;
        }
        String path = f.getAbsolutePath();
        if (FILTER.accept(path)) {
            return false;
        }
        String name = path;
        if (!name.contains(".")) {
            return false;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1, name.length());
        if (ext == null) {
            return false;
        }
        return HCS_FILES_EXTENSION.contains(ext.toLowerCase());
    }

    public static boolean isHCSFormat(String format) {
        Iterator<String> i = HCS_DOMAIN.iterator();
        while (i.hasNext()) {
            if (!format.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOMEFile(File file) {
        if (file == null) {
            return false;
        }
        String name = file.getName();
        if (name == null) {
            return false;
        }
        Iterator<String> i = OME_SUFFIXES.iterator();
        name = name.toLowerCase();
        while (i.hasNext()) {
            String s = i.next().toLowerCase();
            if (!name.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNewObjects() {
        int size = this.newObjects.size();
        if (size > 0) {
            return true;
        }
        return this.projectDatasetMap.size() > 0;
    }

    public void addNewDataObject(DataObject object) {
        if (object != null) {
            this.newObjects.add(object);
        }
    }

    public DataObject hasObjectBeenCreated(DataObject object, SecurityContext ctx) {
        if (object == null) {
            return null;
        }
        Iterator<DataObject> i = this.newObjects.iterator();
        String name = this.getObjectName(object);
        while (i.hasNext()) {
            DataObject data = i.next();
            String n = this.getObjectName(data);
            if (!data.getClass().equals(object.getClass()) || !n.equals(name) || data.getGroupId() != ctx.getGroupID()) continue;
            return data;
        }
        return null;
    }

    public DatasetData isDatasetCreated(long projectID, DatasetData dataset) {
        List<DatasetData> datasets = this.projectDatasetMap.get(projectID);
        if (datasets == null || datasets.size() == 0) {
            return null;
        }
        Iterator<DatasetData> i = datasets.iterator();
        String name = dataset.getName();
        while (i.hasNext()) {
            DatasetData data = i.next();
            if (!data.getName().equals(name)) continue;
            return data;
        }
        return null;
    }

    public void registerDataset(long projectID, DatasetData dataset) {
        if (dataset == null) {
            return;
        }
        List<DatasetData> datasets = this.projectDatasetMap.get(projectID);
        if (datasets == null) {
            datasets = new ArrayList<DatasetData>();
            this.projectDatasetMap.put(projectID, datasets);
        }
        datasets.add(dataset);
    }

    public boolean isFileinQueue(String value) {
        for (ImportableFile f : this.files) {
            if (!f.getFile().getAbsolutePath().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void reUpload(List<ImportableFile> files) {
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        this.files = files;
    }

    public String getChecksumAlgorithm() {
        String option = (String)this.skipChoices.get(OPTION_CHECKSUMS);
        return option != null ? option : "File-Size-64";
    }

    public boolean skipMinMax() {
        Boolean option = (Boolean)this.skipChoices.get(OPTION_SKIP_MINMAX);
        return option != null && option != false;
    }

    public boolean skipThumbnails() {
        Boolean option = (Boolean)this.skipChoices.get(OPTION_THUMBNAILS);
        return option != null && option == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FILTER = new TIFFFilter();
        DEFAULT_DATASET_NAME = UIUtilities.formatDate(null, "dd-MM-yyyy");
        HCS_FILES_EXTENSION = new HashSet<String>();
        HCS_DOMAIN = new ArrayList<String>();
        ImageReader r = new ImageReader();
        IFormatReader[] allReaders = r.getReaders();
        try {
            for (IFormatReader reader : allReaders) {
                if (Arrays.asList(reader.getPossibleDomains("")).contains("High-Content Screening (HCS)")) {
                    ImportableObject.populateExtensions(reader.getSuffixes());
                    HCS_DOMAIN.add(reader.getFormat());
                }
                reader.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
        OMEXMLReader reader = new OMEXMLReader();
        OME_SUFFIXES = Arrays.asList(reader.getSuffixes());
        ARBITRARY_FILES_EXTENSION = new ArrayList<String>();
        ARBITRARY_FILES_EXTENSION.add("text");
        ARBITRARY_FILES_EXTENSION.add("txt");
        ARBITRARY_FILES_EXTENSION.add("xml");
        ARBITRARY_FILES_EXTENSION.add("exp");
        ARBITRARY_FILES_EXTENSION.add("log");
        ARBITRARY_FILES_EXTENSION.add("ini");
        ARBITRARY_FILES_EXTENSION.add(DAT_EXTENSION);
        ARBITRARY_FILES_EXTENSION.add("tiff");
        ARBITRARY_FILES_EXTENSION.add("tif");
        OPTION_THUMBNAILS = "doThumbnails";
        OPTION_SKIP_MINMAX = "noStatsInfo";
        OPTION_CHECKSUMS = "checksumAlgorithm";
    }
}

