/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ImagesLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private BatchCall makeBatchCall(final long userID, final boolean orphan) {
        return new BatchCall("Loading user's images: "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getExperimenterImages(ImagesLoader.this.ctx, userID, orphan);
            }
        };
    }

    private BatchCall makeBatchCall(final long imageID) {
        return new BatchCall("Loading user's images: "){

            @Override
            public void doCall() throws Exception {
                Iterator<ImageData> i;
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                Collection<ImageData> set = os.getImages(ImagesLoader.this.ctx, ImageData.class, Arrays.asList(imageID), -1L);
                if (set != null && set.size() == 1 && (i = set.iterator()).hasNext()) {
                    ImagesLoader.this.results = i.next();
                }
            }
        };
    }

    private BatchCall makeImagesInContainerBatchCall(final Class nodeType, final List nodeIDs, final long userID) {
        return new BatchCall("Loading container tree: "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getImages(ImagesLoader.this.ctx, nodeType, nodeIDs, userID);
            }
        };
    }

    private BatchCall makeBatchCall(final Timestamp startTime, final Timestamp endTime, final long userID) {
        return new BatchCall("Loading images: "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getImagesPeriod(ImagesLoader.this.ctx, startTime, endTime, userID, true);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public ImagesLoader(SecurityContext ctx, long userID, boolean orphan) {
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(userID, orphan);
    }

    public ImagesLoader(SecurityContext ctx, Class nodeType, List nodeIDs, long userID) {
        if (nodeType == null) {
            throw new IllegalArgumentException("No node type.");
        }
        if (nodeIDs == null || nodeIDs.size() == 0) {
            throw new IllegalArgumentException("Collection of node ID not valid.");
        }
        this.ctx = ctx;
        if (!nodeType.equals(DatasetData.class) && !nodeType.equals(ImageData.class)) {
            throw new IllegalArgumentException("Unsupported type: " + nodeType);
        }
        this.loadCall = this.makeImagesInContainerBatchCall(nodeType, nodeIDs, userID);
    }

    public ImagesLoader(SecurityContext ctx, Timestamp startTime, Timestamp endTime, long userID) {
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(startTime, endTime, userID);
    }

    public ImagesLoader(SecurityContext ctx, long imageID) {
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(imageID);
    }
}

