/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.env.rnd.roi.AbstractROIShapeStats;

public class ROIShapeStatsSimple
extends AbstractROIShapeStats {
    private List<Point> points;
    private double[] values;

    public List<Point> getPoints() {
        return this.points;
    }

    public double[] getValues() {
        return this.values;
    }

    public double getValue(Point p) {
        int i = this.points.indexOf(p);
        if (i == -1) {
            return Double.NaN;
        }
        return this.values[i];
    }

    @Override
    public void onEndPlane(int z, int c, int t, int pointsCount) {
        double sigmaSquare;
        if (pointsCount <= 0) {
            return;
        }
        this.mean = this.sum / (double)pointsCount;
        this.pointsCount = pointsCount;
        if (0 < pointsCount - 1 && (sigmaSquare = (this.sumOfSquares - this.sum * this.sum / (double)pointsCount) / (double)(pointsCount - 1)) > 0.0) {
            this.standardDeviation = Math.sqrt(sigmaSquare);
        }
    }

    @Override
    public void update(double pixelValue, int z, int w, int t, Point loc) {
        this.min = Math.min(pixelValue, this.min);
        this.max = Math.max(pixelValue, this.max);
        this.sum += pixelValue;
        this.sumOfSquares += pixelValue * pixelValue;
        this.values[this.points.size()] = pixelValue;
        this.points.add(loc);
    }

    @Override
    public void onStartPlane(int z, int w, int t, int pointsCount) {
        this.points = new ArrayList<Point>();
        this.values = new double[pointsCount];
    }

    @Override
    public void iterationStarted() {
    }

    @Override
    public void iterationFinished() {
    }
}

