/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.transport;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.openmicroscopy.shoola.svc.transport.HttpChannel;
import org.openmicroscopy.shoola.svc.transport.TransportException;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

class BasicChannel
extends HttpChannel {
    static final int DEF_CONN_TIMEOUT = 10000;
    private final String requestPath;
    private final int connTimeout;

    private SSLConnectionSocketFactory createSSLConnection() throws TransportException {
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        X509TrustManager trustEverything = new X509TrustManager(){
            private final X509Certificate[] acceptedIssuers = new X509Certificate[0];

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.acceptedIssuers;
            }
        };
        TrustManager[] managers = new TrustManager[]{trustEverything};
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, managers, null);
        }
        catch (Exception e) {
            throw new TransportException("Cannot create security context", e);
        }
        return new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    BasicChannel(String url, int connTimeout) throws IllegalArgumentException {
        this.requestPath = url;
        this.connTimeout = connTimeout < 0 ? 10000 : connTimeout;
    }

    @Override
    protected CloseableHttpClient getCommunicationLink() throws TransportException {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setCookieSpec("best-match").setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic"));
        builder.setConnectTimeout(this.connTimeout);
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (CommonsLangUtils.isNotBlank(proxyHost) && CommonsLangUtils.isNotBlank(proxyPort)) {
            builder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
        }
        HttpClientBuilder httpBuilder = HttpClients.custom();
        httpBuilder.setDefaultRequestConfig(builder.build());
        String value = this.requestPath;
        if (value.toLowerCase().startsWith("https")) {
            httpBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnection());
        }
        return httpBuilder.build();
    }

    @Override
    protected String getRequestPath() {
        return this.requestPath;
    }
}

