/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colour;

import java.awt.Color;

public class GradientUtil {
    public static final Color[] GRADIENT_BLUE_TO_RED = GradientUtil.createGradient(Color.BLUE, Color.RED);
    public static final Color[] GRADIENT_RED_TO_BLUE = GradientUtil.createGradient(Color.RED, Color.BLUE);
    public static final Color[] GRADIENT_BLACK_TO_WHITE = GradientUtil.createGradient(Color.BLACK, Color.WHITE);
    public static final Color[] GRADIENT_HOT = GradientUtil.createGradient(new Color[]{Color.BLACK, Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, new Color(138, 43, 226), Color.WHITE});
    public static final int STEPS = 500;

    public static Color[] createGradient(Color start, Color end) {
        return GradientUtil.createGradient(start, end, 500);
    }

    public static Color[] createGradient(Color start, Color end, int steps) {
        if (start == null || end == null) {
            return null;
        }
        if (steps <= 1) {
            steps = 2;
        }
        Color[] colors = new Color[steps];
        int r1 = start.getRed();
        int g1 = start.getBlue();
        int b1 = start.getGreen();
        int a1 = start.getAlpha();
        int r2 = end.getRed();
        int g2 = end.getGreen();
        int b2 = end.getGreen();
        int a2 = end.getAlpha();
        for (int i = 0; i < steps; ++i) {
            double norm = (double)i / (double)steps;
            colors[i] = new Color((int)((double)r1 + norm * (double)(r2 - r1)), (int)((double)g1 + norm * (double)(g2 - g1)), (int)((double)b1 + norm * (double)(b2 - b1)), (int)((double)a1 + norm * (double)(a2 - a1)));
        }
        return colors;
    }

    public static Color[] createGradient(Color[] colors) {
        return GradientUtil.createGradient(colors, 500);
    }

    public static Color[] createGradient(Color[] colors, int steps) {
        if (colors == null || colors.length < 2) {
            return null;
        }
        int num = colors.length - 1;
        int index = 0;
        Color[] gradient = new Color[steps];
        for (int j = 0; j < num; ++j) {
            Color[] temp = GradientUtil.createGradient(colors[j], colors[j + 1], steps / num);
            for (int i = 0; i < temp.length; ++i) {
                gradient[index++] = temp[i];
            }
        }
        if (index < steps) {
            while (index < steps) {
                gradient[index] = colors[colors.length - 1];
                ++index;
            }
        }
        return gradient;
    }
}

