/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;

public class LinePlot
extends ChartObject {
    private DefaultXYDataset dataset;
    private List<double[][]> data;
    private StandardXYItemRenderer renderer;

    private void initialize() {
        this.data = new ArrayList<double[][]>();
        this.dataset = new DefaultXYDataset();
        this.renderer = new StandardXYItemRenderer();
    }

    public LinePlot() {
        super("");
        this.initialize();
    }

    public LinePlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
    }

    public LinePlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours, double minValue, double maxValue) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
        this.rangeAxis.setRange(minValue, maxValue);
    }

    public int addSeries(String legend, double[][] newData, Color color) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.addSeries((Comparable)((Object)legend), newData);
        return this.dataset.getSeriesCount();
    }

    public void addLocations(Map<Integer, List<String>> locations) {
        this.renderer.setBaseToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator(locations));
    }

    @Override
    void createChart() {
        for (int i = 0; i < this.colours.size(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)this.colours.get(i));
        }
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)this.domainAxis, (ValueAxis)this.rangeAxis, (XYItemRenderer)this.renderer);
        if (this.backgroundImage != null) {
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            plot.setBackgroundImage(this.backgroundImage);
        }
        this.chart = new JFreeChart(this.title, (Plot)plot);
    }

    class ToolTipGenerator
    implements XYToolTipGenerator {
        private Map<Integer, List<String>> locations;

        public ToolTipGenerator(Map<Integer, List<String>> locations) {
            this.locations = locations;
        }

        public String generateToolTip(XYDataset dataset, int series, int c) {
            if (this.locations == null) {
                return "";
            }
            int x = (int)dataset.getXValue(series, c);
            List<String> values = this.locations.get(series);
            if (CollectionUtils.isEmpty(values)) {
                return "";
            }
            if (x >= 0 && x < values.size()) {
                return values.get(x);
            }
            return "";
        }
    }
}

