/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import ome.services.blitz.repo.path.FsFile;

public class ClientFilePathTransformer {
    private final Function<String, String> pathSanitizer;

    public ClientFilePathTransformer(Function<String, String> pathSanitizer) {
        this.pathSanitizer = pathSanitizer;
    }

    public FsFile getFsFileFromClientFile(File clientFile, int depth) throws IOException {
        if (depth < 1) {
            throw new IllegalArgumentException("path depth must be strictly positive");
        }
        return new FsFile(new FsFile(clientFile), depth).transform(this.pathSanitizer);
    }

    private boolean isDepthSufficient(Collection<File> files, int depth) throws IOException {
        HashSet<FsFile> fsPaths = new HashSet<FsFile>();
        for (File file : files) {
            if (fsPaths.add(this.getFsFileFromClientFile(file, depth))) continue;
            return false;
        }
        return true;
    }

    public int getMinimumDepth(Collection<File> files) throws IOException {
        if (files.size() < 2) {
            return 1;
        }
        if (!this.isDepthSufficient(files, Integer.MAX_VALUE)) {
            throw new IllegalArgumentException("file set is not unique, so no depth can fix it");
        }
        int depth = 1;
        while (!this.isDepthSufficient(files, depth)) {
            ++depth;
        }
        return depth;
    }

    public Set<Collection<File>> getTooSimilarFiles(Set<File> files) throws IOException {
        HashMultimap filesByFsFile = HashMultimap.create();
        for (File file : files) {
            String path = this.getFsFileFromClientFile(file, Integer.MAX_VALUE).toString().toLowerCase();
            filesByFsFile.put((Object)path, (Object)file);
        }
        HashSet<Collection<File>> tooSimilarFiles = new HashSet<Collection<File>>();
        for (Collection similarFiles : filesByFsFile.asMap().values()) {
            if (similarFiles.size() <= 1) continue;
            tooSimilarFiles.add(similarFiles);
        }
        return tooSimilarFiles.isEmpty() ? null : tooSimilarFiles;
    }
}

