/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.services.messages.ContextMessage;
import ome.services.util.ReadOnlyStatus;
import ome.system.OmeroContext;
import ome.util.messages.InternalMessage;
import omero.cmd.DoAll;
import omero.cmd.DoAllRsp;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Request;
import omero.cmd.Response;
import omero.cmd.Status;

public class DoAllI
extends DoAll
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final long serialVersionUID = -323423435135556L;
    private final List<X> substeps = new ArrayList<X>();
    private int current = -1;
    private int nextAt = 0;
    private final List<Status> statuses = new ArrayList<Status>();
    private final List<Response> responses = new ArrayList<Response>();
    private Helper helper;
    private final OmeroContext ctx;

    private X substep(int step, boolean login) {
        X x = null;
        try {
            if (step == 0) {
                x = this.substeps.get(0);
                this.current = 0;
                this.nextAt = x.offset + x.h.getSteps();
                if (login) {
                    x.login();
                }
            } else if (step == this.nextAt) {
                X prev = this.substeps.get(this.current);
                if (login) {
                    prev.logout();
                }
                ++this.current;
                x = this.substeps.get(this.current);
                this.nextAt = x.offset + x.h.getSteps();
                if (login) {
                    x.login();
                }
            } else {
                x = this.substeps.get(this.current);
            }
            return x;
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "substep-lookup-failed", "step", "" + step, "req", x == null ? "null" : "" + x.r);
        }
    }

    public DoAllI(OmeroContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Helper helper) {
        this.helper = helper;
        int steps = 0;
        try {
            HashMap<String, String> allgroups = new HashMap<String, String>();
            allgroups.put("omero.group", "-1");
            for (int i = 0; i < this.requests.size(); ++i) {
                Request req = (Request)((Object)this.requests.get(i));
                Status substatus = new Status();
                Helper subhelper = helper.subhelper(req, substatus);
                if (req instanceof IRequest) {
                    IRequest ireq = (IRequest)((Object)req);
                    X x = new X(steps, subhelper, ireq, this.ctx);
                    try {
                        x.calculateContext(ireq.getCallContext(), this.contexts == null || this.contexts.length <= i ? null : this.contexts[i]);
                        x.login();
                        try {
                            ireq.init(subhelper);
                            this.statuses.add(substatus);
                            this.substeps.add(x);
                            long intermediate = substatus.steps;
                            if (intermediate + (long)steps > Integer.MAX_VALUE) {
                                throw helper.cancel(new ERR(), null, "too-many-steps", "Steps", "" + intermediate, "Message", "Too many steps found! Try fewer actions in one command");
                            }
                            steps = (int)((long)steps + intermediate);
                            continue;
                        }
                        finally {
                            x.logout();
                        }
                    }
                    catch (HandleI.Cancel c) {
                        throw this.subcancel(c, x);
                    }
                }
                throw helper.cancel(new ERR(), null, "bad-request", "type", req.ice_id());
            }
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (Throwable t) {
            helper.cancel(new ERR(), t, "bad-init", new String[0]);
        }
        helper.setSteps(steps);
    }

    @Override
    public Object step(int step) {
        this.helper.assertStep(step);
        X x = this.substep(step, true);
        try {
            return x.step(step);
        }
        catch (HandleI.Cancel c) {
            throw this.subcancel(c, x);
        }
    }

    @Override
    public void finish() {
        for (X x : this.substeps) {
            try {
                x.login();
                try {
                    x.r.finish();
                }
                finally {
                    x.logout();
                }
            }
            catch (HandleI.Cancel c) {
                throw this.subcancel(c, x);
            }
            catch (Throwable t) {
                this.helper.cancel(new ERR(), t, "bad-finish", new String[0]);
            }
        }
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        X x = this.substep(step, false);
        x.buildResponse(step, object);
        if (this.helper.isLast(step)) {
            for (Request subreq : this.requests) {
                IRequest ireq = (IRequest)((Object)subreq);
                this.responses.add(ireq.getResponse());
            }
            DoAllRsp rsp = new DoAllRsp(this.responses, this.statuses);
            this.helper.setResponseIfNull(rsp);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    protected HandleI.Cancel subcancel(HandleI.Cancel c, X x) {
        Response subrsp = x.h.getResponse();
        Status substatus = x.h.getStatus();
        Status status = this.helper.getStatus();
        this.helper.setResponseIfNull(subrsp);
        status.flags.addAll(substatus.flags);
        if (status.parameters == null) {
            status.parameters = new HashMap<String, String>();
        }
        if (substatus.parameters != null) {
            status.parameters.putAll(substatus.parameters);
        }
        status.parameters.put("subrequest", "" + (Object)((Object)subrsp));
        status.category = this.ice_id();
        status.name = "subcancel";
        throw c;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        for (Request request : this.requests) {
            if (request instanceof ReadOnlyStatus.IsAware && ((ReadOnlyStatus.IsAware)((Object)request)).isReadOnly(readOnly)) continue;
            return false;
        }
        return true;
    }

    private static class X {
        final int offset;
        final Helper h;
        final IRequest r;
        final OmeroContext ctx;
        Map<String, String> c = null;

        X(int offset, Helper h, IRequest r, OmeroContext ctx) {
            this.offset = offset;
            this.h = h;
            this.r = r;
            this.ctx = ctx;
        }

        Object step(int step) {
            int substep;
            this.h.getStatus().currentStep = substep = step - this.offset;
            return this.r.step(substep);
        }

        void buildResponse(int step, Object object) {
            this.r.buildResponse(step - this.offset, object);
        }

        void calculateContext(Map<String, String> classContext, Map<String, String> callContext) {
            this.putAll(classContext);
            this.putAll(callContext);
        }

        private void putAll(Map<String, String> context) {
            if (context != null && context.size() > 0) {
                if (this.c == null) {
                    this.c = new HashMap<String, String>();
                }
                this.c.putAll(context);
            }
        }

        void login() throws Throwable {
            if (this.c != null) {
                this.h.debug("Login: %s", this.c);
                this.ctx.publishMessage((InternalMessage)new ContextMessage.Push(this, this.c));
            }
        }

        void logout() throws Throwable {
            if (this.c != null) {
                this.ctx.publishMessage((InternalMessage)new ContextMessage.Pop(this, this.c));
            }
        }
    }
}

