/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DateString
implements Comparable<DateString> {
    private static final Pattern PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]");
    final String v;

    private DateString(String v, boolean ignore) {
        this.v = v;
    }

    public DateString(String v) {
        this(v, false);
        Preconditions.checkArgument((boolean)PATTERN.matcher(v).matches(), (String)"Invalid date format:", (Object[])new Object[]{v});
        Preconditions.checkArgument((this.getYear() >= 1 && this.getYear() <= 9999 ? 1 : 0) != 0, (String)"Year out of range:", (Object[])new Object[]{this.getYear()});
        Preconditions.checkArgument((this.getMonth() >= 1 && this.getMonth() <= 12 ? 1 : 0) != 0, (String)"Month out of range:", (Object[])new Object[]{this.getMonth()});
        Preconditions.checkArgument((this.getDay() >= 1 && this.getDay() <= 31 ? 1 : 0) != 0, (String)"Day out of range:", (Object[])new Object[]{this.getDay()});
    }

    public DateString(int year, int month, int day) {
        this(DateString.ymd(year, month, day), true);
    }

    private static String ymd(int year, int month, int day) {
        Preconditions.checkArgument((year >= 1 && year <= 9999 ? 1 : 0) != 0, (String)"Year out of range:", (Object[])new Object[]{year});
        Preconditions.checkArgument((month >= 1 && month <= 12 ? 1 : 0) != 0, (String)"Month out of range:", (Object[])new Object[]{month});
        Preconditions.checkArgument((day >= 1 && day <= 31 ? 1 : 0) != 0, (String)"Day out of range:", (Object[])new Object[]{day});
        StringBuilder b = new StringBuilder();
        DateTimeStringUtils.ymd(b, year, month, day);
        return b.toString();
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof DateString && ((DateString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(DateString o) {
        return this.v.compareTo(o.v);
    }

    public static DateString fromCalendarFields(Calendar calendar) {
        return new DateString(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public int getDaysSinceEpoch() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        return DateTimeUtils.ymdToUnixDate((int)year, (int)month, (int)day);
    }

    private int getYear() {
        return Integer.parseInt(this.v.substring(0, 4));
    }

    private int getMonth() {
        return Integer.parseInt(this.v.substring(5, 7));
    }

    private int getDay() {
        return Integer.parseInt(this.v.substring(8, 10));
    }

    @JsonCreator
    public static DateString fromDaysSinceEpoch(@JsonProperty(value="daysSinceEpoch") int days) {
        return new DateString(DateTimeUtils.unixDateToString((int)days));
    }

    @JsonIgnore
    public long getMillisSinceEpoch() {
        return (long)this.getDaysSinceEpoch() * 86400000L;
    }

    public Calendar toCalendar() {
        return Util.calendar(this.getMillisSinceEpoch());
    }
}

