/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class SeikoReader
extends FormatReader {
    private static final int HEADER_SIZE = 2944;

    public SeikoReader() {
        super("Seiko", new String[]{"xqd", "xqf"});
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(2944L);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        String comment = null;
        double xSize = 0.0;
        double ySize = 0.0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.seek(40L);
            comment = this.in.readCString();
            this.in.seek(156L);
            xSize = this.in.readFloat();
            this.in.skipBytes(4);
            ySize = this.in.readFloat();
            this.addGlobalMeta("Comment", comment);
        }
        this.in.seek(1402L);
        m.sizeX = this.in.readShort();
        m.sizeY = this.in.readShort();
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        m.pixelType = 3;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(comment, 0);
            Length sizeX = FormatTools.getPhysicalSizeX((Double)xSize);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)ySize);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

