/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.core.codec.core;

import com.fasterxml.jackson.annotation.JsonValue;
import dev.zarr.zarrjava.core.codec.ArrayBytesCodec;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public abstract class BytesCodec
extends ArrayBytesCodec {
    protected abstract ByteOrder getByteOrder();

    @Override
    public Array decode(ByteBuffer chunkBytes) {
        chunkBytes.order(this.getByteOrder());
        return Array.factory((DataType)this.arrayMetadata.dataType.getMA2DataType(), (int[])this.arrayMetadata.chunkShape, (ByteBuffer)chunkBytes);
    }

    @Override
    public ByteBuffer encode(Array chunkArray) {
        return chunkArray.getDataAsByteBuffer(this.getByteOrder());
    }

    public static enum Endian {
        LITTLE("little"),
        BIG("big");

        private final String endian;

        private Endian(String endian) {
            this.endian = endian;
        }

        @JsonValue
        public String getValue() {
            return this.endian;
        }

        public ByteOrder getByteOrder() {
            switch (this) {
                case LITTLE: {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                case BIG: {
                    return ByteOrder.BIG_ENDIAN;
                }
            }
            throw new RuntimeException("Unreachable");
        }
    }
}

