/*
 * Decompiled with CFR 0.152.
 */
import ch.qos.logback.classic.Level;
import java.nio.ByteBuffer;
import loci.common.services.ServiceFactory;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;
import ome.units.quantity.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrthogonalReader {
    private static final Logger log = LoggerFactory.getLogger(OrthogonalReader.class);
    private String input;
    private String output;
    private boolean debug;

    public static void main(String[] args) throws Throwable {
        log.info("Orthogonal reader started");
        OrthogonalReader main = new OrthogonalReader();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--input")) {
                main.setInputFile(args[i + 1]);
                continue;
            }
            if (args[i].equals("--output")) {
                main.setOutputFile(args[i + 1]);
                continue;
            }
            if (!args[i].equals("--debug")) continue;
            main.setDebug(true);
        }
        main.readOrthogonalPlanes();
    }

    public void setInputFile(String input) {
        this.input = input;
    }

    public void setOutputFile(String output) {
        this.output = output;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private ImageReader initialiseReader(String fileName) throws Exception {
        ImageReader reader = new ImageReader();
        reader.setId(fileName);
        return reader;
    }

    private OMETiffWriter initialiseWriter(String fileName, ImageReader reader) throws Exception {
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata metadata = service.createOMEXMLMetadata();
        MetadataRetrieve mr = (MetadataRetrieve)reader.getMetadataStore();
        Length originalSizeX = mr.getPixelsPhysicalSizeX(0);
        Length originalSizeY = mr.getPixelsPhysicalSizeY(0);
        Length originalSizeZ = mr.getPixelsPhysicalSizeZ(0);
        MetadataTools.populateMetadata((MetadataStore)metadata, (int)0, (String)"XZ", (boolean)reader.isLittleEndian(), (String)reader.getDimensionOrder(), (String)FormatTools.getPixelTypeString((int)reader.getPixelType()), (int)reader.getSizeX(), (int)reader.getSizeZ(), (int)reader.getSizeY(), (int)1, (int)1, (int)1);
        metadata.setPixelsPhysicalSizeX(originalSizeX, 0);
        metadata.setPixelsPhysicalSizeY(originalSizeZ, 0);
        metadata.setPixelsPhysicalSizeZ(originalSizeY, 0);
        MetadataTools.populateMetadata((MetadataStore)metadata, (int)1, (String)"YZ", (boolean)reader.isLittleEndian(), (String)reader.getDimensionOrder(), (String)FormatTools.getPixelTypeString((int)reader.getPixelType()), (int)reader.getSizeY(), (int)reader.getSizeZ(), (int)reader.getSizeX(), (int)1, (int)1, (int)1);
        metadata.setPixelsPhysicalSizeX(originalSizeY, 1);
        metadata.setPixelsPhysicalSizeY(originalSizeZ, 1);
        metadata.setPixelsPhysicalSizeZ(originalSizeX, 1);
        OMETiffWriter writer = new OMETiffWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)metadata);
        writer.setId(fileName);
        return writer;
    }

    private void readOrthogonalPlanes() throws Exception {
        byte[] line;
        int index;
        int z;
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        if (this.debug) {
            root.setLevel(Level.DEBUG);
        } else {
            root.setLevel(Level.INFO);
        }
        ImageReader reader = this.initialiseReader(this.input);
        reader.setSeries(0);
        OMETiffWriter writer = this.initialiseWriter(this.output, reader);
        writer.setSeries(0);
        for (int y = 0; y < reader.getSizeY(); ++y) {
            ByteBuffer bufferXZ = ByteBuffer.allocate((int)(0.125 * (double)reader.getBitsPerPixel()) * reader.getSizeX() * reader.getSizeZ());
            for (z = 0; z < reader.getSizeZ(); ++z) {
                index = reader.getIndex(z, 0, 0);
                line = reader.openBytes(index, 0, y, reader.getSizeX(), 1);
                bufferXZ.put(line);
            }
            log.debug("y: {}, {}", (Object)y, (Object)bufferXZ.array().length);
            writer.saveBytes(y, bufferXZ.array());
        }
        writer.setSeries(1);
        for (int x = 0; x < reader.getSizeX(); ++x) {
            ByteBuffer bufferYZ = ByteBuffer.allocate((int)(0.125 * (double)reader.getBitsPerPixel()) * reader.getSizeY() * reader.getSizeZ());
            for (z = 0; z < reader.getSizeZ(); ++z) {
                index = reader.getIndex(z, 0, 0);
                line = reader.openBytes(index, x, 0, 1, reader.getSizeY());
                bufferYZ.put(line);
            }
            log.debug("x: {}, {}", (Object)x, (Object)bufferYZ.array().length);
            writer.saveBytes(x, bufferYZ.array());
        }
        reader.close();
        writer.close();
    }
}

