/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import com.google.api.client.util.Key;
import io.minio.DateFormat;
import io.minio.messages.XmlEntity;
import java.util.Date;
import org.xmlpull.v1.XmlPullParserException;

public class Part
extends XmlEntity {
    @Key(value="PartNumber")
    private int partNumber;
    @Key(value="ETag")
    private String etag;
    @Key(value="LastModified")
    private String lastModified;
    @Key(value="Size")
    private Long size;

    public Part() throws XmlPullParserException {
        this(0, null);
    }

    public Part(int partNumber, String etag) throws XmlPullParserException {
        this.name = "Part";
        this.partNumber = partNumber;
        this.etag = etag;
    }

    public int partNumber() {
        return this.partNumber;
    }

    public String etag() {
        return this.etag.replaceAll("\"", "");
    }

    public Date lastModified() {
        return DateFormat.RESPONSE_DATE_FORMAT.parseDateTime(this.lastModified).toDate();
    }

    public long partSize() {
        return this.size;
    }
}

