/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;

public class AliconaReader
extends FormatReader {
    public static final String AL3D_MAGIC_STRING = "Alicona";
    private int textureOffset;
    private int numBytes;

    public AliconaReader() {
        super("Alicona AL3D", "al3d");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).indexOf(AL3D_MAGIC_STRING) >= 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int pad = (8 - this.getSizeX() % 8) % 8;
        int planeSize = (this.getSizeX() + pad) * this.getSizeY();
        if (this.getPixelType() == 6) {
            this.in.seek(this.textureOffset);
            this.readPlane(this.in, x, y, w, h2, buf);
            return buf;
        }
        for (int i = 0; i < this.numBytes; ++i) {
            this.in.seek(this.textureOffset + no * planeSize * (i + 1));
            this.in.skipBytes((long)y * (long)(this.getSizeX() + pad));
            if (this.getSizeX() == w) {
                this.in.read(buf, i * w * h2, w * h2);
                continue;
            }
            for (int row = 0; row < h2; ++row) {
                this.in.skipBytes(x);
                this.in.read(buf, i * w * h2 + row * w, w);
                this.in.skipBytes(this.getSizeX() + pad - x - w);
            }
        }
        if (this.numBytes > 1) {
            byte[] tmp = new byte[buf.length];
            for (int i = 0; i < planeSize; ++i) {
                for (int j = 0; j < this.numBytes; ++j) {
                    tmp[i * this.numBytes + j] = buf[planeSize * j + i];
                }
            }
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
            tmp = null;
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.numBytes = 0;
            this.textureOffset = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying Alicona format");
        String magicString = this.in.readString(17);
        if (!magicString.trim().equals("AliconaImaging")) {
            throw new FormatException("Invalid magic string : expected 'AliconaImaging', got " + magicString);
        }
        LOGGER.info("Reading tags");
        int count = 2;
        boolean hasC = false;
        String voltage = null;
        String magnification = null;
        String workingDistance = null;
        String pntX = null;
        String pntY = null;
        int depthOffset = 0;
        for (int i = 0; i < count; ++i) {
            String key = this.in.readString(20).trim();
            String value = this.in.readString(30).trim();
            this.addGlobalMeta(key, value);
            this.in.skipBytes(2);
            if (key.equals("TagCount")) {
                count += Integer.parseInt(value);
                continue;
            }
            if (key.equals("Rows")) {
                m4.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("Cols")) {
                m4.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("NumberOfPlanes")) {
                m4.imageCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TextureImageOffset")) {
                this.textureOffset = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TexturePtr") && !value.equals("7")) {
                hasC = true;
                continue;
            }
            if (key.equals("Voltage")) {
                voltage = value;
                continue;
            }
            if (key.equals("Magnification")) {
                magnification = value;
                continue;
            }
            if (key.equals("PixelSizeXMeter")) {
                pntX = value;
                continue;
            }
            if (key.equals("PixelSizeYMeter")) {
                pntY = value;
                continue;
            }
            if (key.equals("WorkingDistance")) {
                workingDistance = value;
                continue;
            }
            if (!key.equals("DepthImageOffset")) continue;
            depthOffset = Integer.parseInt(value);
        }
        LOGGER.info("Populating metadata");
        if (this.textureOffset != 0) {
            this.numBytes = (int)(this.in.length() - (long)this.textureOffset) / (this.getSizeX() * this.getSizeY() * this.getImageCount());
            m4.sizeC = hasC ? 3 : 1;
            m4.sizeZ = 1;
            m4.sizeT = this.getImageCount() / this.getSizeC();
            m4.pixelType = FormatTools.pixelTypeFromBytes(this.numBytes, false, false);
        } else {
            this.textureOffset = depthOffset;
            m4.pixelType = 6;
            m4.sizeC = 1;
            m4.sizeZ = 1;
            m4.sizeT = 1;
            m4.imageCount = 1;
        }
        m4.rgb = false;
        m4.interleaved = false;
        m4.littleEndian = true;
        m4.dimensionOrder = "XYCTZ";
        m4.metadataComplete = true;
        m4.indexed = false;
        m4.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            if (voltage != null) {
                store.setDetectorSettingsVoltage(new ElectricPotential(DataTools.parseDouble(voltage), UNITS.VOLT), 0, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorSettingsID(detectorID, 0, 0);
                store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, 0);
            }
            if (magnification != null) {
                store.setObjectiveCalibratedMagnification(DataTools.parseDouble(magnification), 0, 0);
            }
            if (workingDistance != null) {
                store.setObjectiveWorkingDistance(new Length(DataTools.parseDouble(workingDistance), UNITS.MICROMETER), 0, 0);
            }
            store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
            if (pntX != null && pntY != null) {
                double pixelSizeX = Double.parseDouble(pntX);
                double pixelSizeY = Double.parseDouble(pntY);
                Length sizeX = FormatTools.getPhysicalSizeX((Double)pixelSizeX, UNITS.METER);
                Length sizeY = FormatTools.getPhysicalSizeY((Double)pixelSizeY, UNITS.METER);
                if (sizeX != null) {
                    store.setPixelsPhysicalSizeX(sizeX, 0);
                }
                if (sizeY != null) {
                    store.setPixelsPhysicalSizeY(sizeY, 0);
                }
            }
        }
    }
}

