/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

public class Dimension {
    public DimensionKey key;
    public int size;
    public long bytesInc;
    public String unit = null;
    private Double length = 0.0;
    private Double offByOneLength = 0.0;
    public boolean oldPhysicalSize = false;
    public int frameIndex = 0;
    private static final long METER_MULTIPLY = 1000000L;

    public Dimension(DimensionKey key, int size, long bytesInc, String unit, Double length, boolean oldPhysicalSize) {
        this.key = key;
        this.size = size;
        this.bytesInc = bytesInc;
        this.unit = unit;
        this.oldPhysicalSize = oldPhysicalSize;
        this.setLength(length);
    }

    private Dimension() {
    }

    public static Dimension createChannelDimension(int channelNumber, long bytesInc) {
        Dimension dimension = new Dimension();
        dimension.bytesInc = bytesInc;
        dimension.size = channelNumber;
        dimension.key = DimensionKey.C;
        return dimension;
    }

    public void setLength(Double length) {
        this.length = length;
        this.offByOneLength = 0.0;
        if (this.size > 1) {
            this.offByOneLength = this.length / (double)this.size;
            this.length = this.length / (double)(this.size - 1);
        } else {
            this.length = 0.0;
        }
        if (this.unit.equals("Ks")) {
            this.length = this.length / 1000.0;
            this.offByOneLength = this.offByOneLength / 1000.0;
        } else if (this.unit.equals("m")) {
            this.length = this.length * 1000000.0;
            this.offByOneLength = this.offByOneLength * 1000000.0;
        }
    }

    public Double getLength() {
        if (this.key == DimensionKey.X || this.key == DimensionKey.Y) {
            return this.oldPhysicalSize ? this.offByOneLength : this.length;
        }
        return this.length;
    }

    public static enum DimensionKey {
        X(1, 'X'),
        Y(2, 'Y'),
        Z(3, 'Z'),
        T(4, 'T'),
        C(5, 'C'),
        S(10, 'S');

        public int id;
        public char token;

        private DimensionKey(int id, char token) {
            this.id = id;
            this.token = token;
        }

        public static DimensionKey with(int id) {
            for (DimensionKey key : DimensionKey.values()) {
                if (key.id != id) continue;
                return key;
            }
            return null;
        }
    }
}

